/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.openjena.atlas.lib.RefLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSet<T>
implements Iterable<T> {
    private Map<T, RefLong> map = new HashMap<T, RefLong>();
    private int multiSetSize = 0;

    private RefLong _get(T obj) {
        RefLong z = this.map.get(obj);
        if (z == null) {
            z = new RefLong(0L);
            this.map.put(obj, z);
        }
        return z;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(T obj) {
        return this.map.containsKey(obj);
    }

    public Iterator<T> elements() {
        return this.map.keySet().iterator();
    }

    public void add(T obj) {
        this._get(obj).inc();
        ++this.multiSetSize;
    }

    public void add(T obj, long n) {
        if (n <= 0L) {
            return;
        }
        this._get(obj).add(n);
        this.multiSetSize = (int)((long)this.multiSetSize + n);
    }

    public void remove(T obj) {
        RefLong x = this.map.get(obj);
        if (x == null) {
            return;
        }
        x.dec();
        --this.multiSetSize;
        if (x.value() == 0L) {
            this.map.remove(obj);
        }
    }

    public void remove(T obj, long n) {
        RefLong x = this.map.get(obj);
        if (x == null) {
            return;
        }
        long z = x.value();
        if (z < n) {
            n = z;
        }
        x.subtract(n);
        this.multiSetSize = (int)((long)this.multiSetSize - n);
        if (x.value() <= 0L) {
            this.map.remove(obj);
        }
    }

    public void removeAll(T obj) {
        RefLong x = this.map.get(obj);
        if (x == null) {
            return;
        }
        this.multiSetSize = (int)((long)this.multiSetSize - x.value());
        this.map.remove(obj);
    }

    public void clear() {
        this.map.clear();
        this.multiSetSize = 0;
    }

    public long count(T obj) {
        if (!this.map.containsKey(obj)) {
            return 0L;
        }
        return this.map.get(obj).value();
    }

    public int size() {
        return this.multiSetSize;
    }

    private Iterator<T> iterator1() {
        ArrayList<T> expanded = new ArrayList<T>();
        for (Map.Entry<T, RefLong> e2 : this.map.entrySet()) {
            int i = 0;
            while ((long)i < e2.getValue().value()) {
                expanded.add(e2.getKey());
                ++i;
            }
        }
        return expanded.iterator();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            Iterator<T> keys;
            T key;
            long keyCount;
            T slot;
            {
                this.keys = MultiSet.this.map.keySet().iterator();
                this.key = null;
                this.keyCount = 0L;
                this.slot = null;
            }

            @Override
            public boolean hasNext() {
                if (this.slot != null) {
                    return true;
                }
                if (this.keys == null) {
                    return false;
                }
                if (this.key != null) {
                    if (this.keyCount < MultiSet.this.count(this.key)) {
                        ++this.keyCount;
                        this.slot = this.key;
                        return true;
                    }
                    this.key = null;
                }
                if (this.keys.hasNext()) {
                    this.key = this.keys.next();
                    this.keyCount = 1L;
                    this.slot = this.key;
                    return true;
                }
                this.keys = null;
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object x = this.slot;
                this.slot = null;
                return x;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String sep = "";
        for (Map.Entry<T, RefLong> e2 : this.map.entrySet()) {
            sb.append(sep);
            sep = ", ";
            sb.append(e2.getKey().toString());
            sb.append("=");
            sb.append(Long.toString(e2.getValue().value()));
        }
        sb.append("}");
        return sb.toString();
    }
}

