/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json.io.parserjavacc;

import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.json.io.JSONHandler;

public class JSONPrinter
implements JSONHandler {
    IndentedWriter out;

    public void startParse(long currLine, long currCol) {
        this.out = new IndentedWriter(System.out, true);
    }

    public void finishParse(long currLine, long currCol) {
        this.out.flush();
    }

    public void startObject(long currLine, long currCol) {
        this.out.println(">>Object");
        this.out.incIndent();
    }

    public void finishObject(long currLine, long currCol) {
        this.out.decIndent();
        this.out.println("<<Object");
    }

    public void startPair(long currLine, long currCol) {
        this.out.println(">Pair");
        this.out.incIndent();
    }

    public void keyPair(long currLine, long currCol) {
    }

    public void finishPair(long currLine, long currCol) {
        this.out.decIndent();
        this.out.println("<Pair");
    }

    public void startArray(long currLine, long currCol) {
        this.out.println(">>Array");
        this.out.incIndent();
    }

    public void element(long currLine, long currCol) {
    }

    public void finishArray(long currLine, long currCol) {
        this.out.decIndent();
        this.out.println("<<Array");
    }

    public void valueBoolean(boolean b, long currLine, long currCol) {
        this.out.println("Boolean: " + b);
    }

    public void valueDecimal(String image, long currLine, long currCol) {
        this.out.println("Decimal: " + image);
    }

    public void valueDouble(String image, long currLine, long currCol) {
        this.out.println("Double: " + image);
    }

    public void valueInteger(String image, long currLine, long currCol) {
        this.out.println("Integer: " + image);
    }

    public void valueNull(long currLine, long currCol) {
        this.out.println("Null");
    }

    public void valueString(String image, long currLine, long currCol) {
        this.out.println("String: " + image);
    }
}

