/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushbackIterator<T>
implements Iterator<T> {
    private Deque<T> items = new ArrayDeque<T>();
    private Iterator<T> iter;

    public PushbackIterator(Iterator<T> iter) {
        if (iter == null) {
            throw new IllegalArgumentException("Wrapped iterator can't be null");
        }
        this.iter = iter;
    }

    public void pushback(T item) {
        this.items.push(item);
    }

    @Override
    public boolean hasNext() {
        if (!this.items.isEmpty()) {
            return true;
        }
        return this.iter.hasNext();
    }

    @Override
    public T next() {
        if (!this.items.isEmpty()) {
            return this.items.pop();
        }
        return this.iter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

