/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.data;

import org.openjena.atlas.data.SerializationFactory;
import org.openjena.atlas.data.ThresholdPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdPolicyMemory<T>
implements ThresholdPolicy<T> {
    protected final SerializationFactory<T> serializerFactory;
    protected final long threshold;
    protected long count;
    protected long size;

    public ThresholdPolicyMemory(long threshold, SerializationFactory<T> serializerFactory) {
        if (threshold < 0L) {
            throw new IllegalArgumentException("Threshold must be greater than or equal to zero");
        }
        this.threshold = threshold;
        this.serializerFactory = serializerFactory;
        this.reset();
    }

    @Override
    public void increment(T item) {
        ++this.count;
        this.size += this.serializerFactory.getEstimatedMemorySize(item);
    }

    @Override
    public boolean isThresholdExceeded() {
        return this.size >= this.threshold;
    }

    @Override
    public void reset() {
        this.count = 0L;
        this.size = 0L;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public long getCount() {
        return this.count;
    }

    public long getMemorySize() {
        return this.size;
    }

    public String toString() {
        return "ThresholdPolicyMemory:  Threshold (bytes)=" + this.threshold + "  Memory Size (bytes)=" + this.size + "  Count=" + this.count;
    }
}

