/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.data.DistinctDataBag;
import org.openjena.atlas.data.SerializationFactory;
import org.openjena.atlas.data.ThresholdPolicy;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.FileOps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistinctDataNet<E>
extends DistinctDataBag<E> {
    protected File firstSpillFile;

    public DistinctDataNet(ThresholdPolicy<E> policy, SerializationFactory<E> serializerFactory, Comparator<E> comparator) {
        super(policy, serializerFactory, comparator);
    }

    public boolean netAdd(E item) {
        long s = this.size;
        super.add(item);
        return !this.spilled && this.size > s;
    }

    @Override
    protected void registerSpillFile(File spillFile) {
        if (!this.spilled) {
            this.firstSpillFile = spillFile;
        } else {
            super.registerSpillFile(spillFile);
        }
    }

    @Override
    protected void deleteSpillFiles() {
        super.deleteSpillFiles();
        if (null != this.firstSpillFile) {
            FileOps.delete(this.firstSpillFile, false);
            this.firstSpillFile = null;
        }
    }

    @Override
    protected List<File> getSpillFiles() {
        ArrayList<File> toReturn = new ArrayList<File>(super.getSpillFiles());
        if (null != this.firstSpillFile) {
            toReturn.add(this.firstSpillFile);
        }
        return toReturn;
    }

    protected List<File> getNetSpillFiles() {
        return super.getSpillFiles();
    }

    public Iterator<E> netIterator() {
        Iterator blacklist;
        if (!this.spilled) {
            return Iter.nullIter();
        }
        try {
            blacklist = this.getInputIterator(this.firstSpillFile);
        }
        catch (FileNotFoundException e2) {
            throw new AtlasException("Cannot find the first spill file", e2);
        }
        Iterator rest = super.iterator();
        SortedDiffIterator sdi = SortedDiffIterator.create(rest, blacklist, this.comparator);
        this.registerCloseableIterator(sdi);
        return sdi;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SortedDiffIterator<T>
    implements Iterator<T>,
    Closeable {
        private final Iterator<T> grayList;
        private final Iterator<T> blackList;
        private final Comparator<? super T> comp;
        private boolean finished = false;
        private boolean blackSlotFull = false;
        private T white;
        private T black;

        public static <S extends Comparable<? super S>> SortedDiffIterator<S> create(Iterator<S> first, Iterator<S> second) {
            return SortedDiffIterator.create(first, second, new Comparator<S>(){

                @Override
                public int compare(S o1, S o2) {
                    if (null == o1 && null == o2) {
                        return 0;
                    }
                    if (null == o1) {
                        return -1;
                    }
                    if (null == o2) {
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
        }

        public static <S> SortedDiffIterator<S> create(Iterator<S> first, Iterator<S> second, Comparator<? super S> comparator) {
            return new SortedDiffIterator<S>(first, second, comparator);
        }

        private SortedDiffIterator(Iterator<T> first, Iterator<T> second, Comparator<? super T> comparator) {
            this.grayList = first;
            this.blackList = second;
            this.comp = comparator;
            this.fill();
        }

        private void fill() {
            if (this.finished) {
                return;
            }
            if (!this.grayList.hasNext()) {
                this.close();
                return;
            }
            if (!this.blackSlotFull) {
                if (!this.blackList.hasNext()) {
                    this.white = this.grayList.next();
                    return;
                }
                this.black = this.blackList.next();
                this.blackSlotFull = true;
            }
            block0: while (true) {
                if (!this.grayList.hasNext()) {
                    this.close();
                    return;
                }
                this.white = this.grayList.next();
                int cmp = this.comp.compare(this.white, this.black);
                if (cmp < 0) {
                    return;
                }
                do {
                    if (cmp <= 0) continue block0;
                    if (!this.blackList.hasNext()) {
                        this.black = null;
                        this.blackSlotFull = false;
                        return;
                    }
                    this.black = this.blackList.next();
                } while ((cmp = this.comp.compare(this.white, this.black)) >= 0);
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.finished;
        }

        @Override
        public T next() {
            if (this.finished) {
                throw new NoSuchElementException();
            }
            T toReturn = this.white;
            this.fill();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SortedDiffIterator.remove");
        }

        @Override
        public void close() {
            this.finished = true;
            this.white = null;
            this.black = null;
            Iter.close(this.grayList);
            Iter.close(this.blackList);
        }
    }
}

