/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path.eval;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.path.P_NegPropSet;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.eval.PathEval;
import com.hp.hpl.jena.sparql.path.eval.PathEvaluator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PathEngine {
    protected static Transform<Triple, Node> selectSubject = new Transform<Triple, Node>(){

        @Override
        public Node convert(Triple triple) {
            return triple.getSubject();
        }
    };
    protected static Transform<Triple, Node> selectPredicate = new Transform<Triple, Node>(){

        @Override
        public Node convert(Triple triple) {
            return triple.getPredicate();
        }
    };
    protected static Transform<Triple, Node> selectObject = new Transform<Triple, Node>(){

        @Override
        public Node convert(Triple triple) {
            return triple.getObject();
        }
    };

    protected final Iter<Node> eval(Graph graph, Path path, Node node) {
        return PathEval.eval$(graph, node, path, this);
    }

    protected final void eval(Graph graph, Path path, Node node, Collection<Node> output) {
        PathEval.eval$(graph, node, path, this, output);
    }

    protected abstract void flipDirection();

    protected abstract boolean direction();

    protected abstract Collection<Node> collector();

    protected final Iterator<Node> doOne(Graph graph, Node node, Node property) {
        Iter<Node> iter2 = null;
        if (this.direction()) {
            Iter<Triple> iter1 = Iter.iter(graph.find(node, property, Node.ANY));
            iter2 = iter1.map(selectObject);
        } else {
            Iter<Triple> iter1 = Iter.iter(graph.find(Node.ANY, property, node));
            iter2 = iter1.map(selectSubject);
        }
        return iter2;
    }

    protected abstract void doSeq(Path var1, Path var2, Node var3, Collection<Node> var4);

    protected abstract void doAlt(Path var1, Path var2, Node var3, Collection<Node> var4);

    protected abstract void doZeroOrMore(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doOneOrMore(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doZeroOrOne(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doNegatedPropertySet(P_NegPropSet var1, Node var2, Collection<Node> var3);

    protected void doZeroOrMoreN(Path pathStep, Node node, Collection<Node> output) {
        this.doZeroOrMore(pathStep, node, output);
    }

    protected void doOneOrMoreN(Path pathStep, Node node, Collection<Node> output) {
        this.doOneOrMore(pathStep, node, output);
    }

    protected abstract void doZero(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doFixedLengthPath(Path var1, Node var2, long var3, Collection<Node> var5);

    protected abstract void doMultiLengthPath(Path var1, Node var2, long var3, long var5, Collection<Node> var7);

    protected final void fill(Iterator<Node> iter, Collection<Node> output) {
        while (iter.hasNext()) {
            output.add(iter.next());
        }
    }

    protected static long dec(long x) {
        return x <= 0L ? x : x - 1L;
    }

    protected static Iterator<Node> stepExcludeForwards(Graph graph, Node node, List<Node> excludedNodes) {
        Iter<Triple> iter1 = PathEngine.forwardLinks(graph, node, excludedNodes);
        Iter<Node> r1 = iter1.map(selectObject);
        return r1;
    }

    protected static Iterator<Node> stepExcludeBackwards(Graph graph, Node node, List<Node> excludedNodes) {
        Iter<Triple> iter1 = PathEngine.backwardLinks(graph, node, excludedNodes);
        Iter<Node> r1 = iter1.map(selectSubject);
        return r1;
    }

    protected static Iter<Triple> forwardLinks(Graph graph, Node x, Collection<Node> excludeProperties) {
        Iter<Triple> iter1 = Iter.iter(graph.find(x, Node.ANY, Node.ANY));
        if (excludeProperties != null) {
            iter1 = iter1.filter(new PathEvaluator.FilterExclude(excludeProperties));
        }
        return iter1;
    }

    protected static Iter<Triple> backwardLinks(Graph graph, Node x, Collection<Node> excludeProperties) {
        Iter<Triple> iter1 = Iter.iter(graph.find(Node.ANY, Node.ANY, x));
        if (excludeProperties != null) {
            iter1 = iter1.filter(new PathEvaluator.FilterExclude(excludeProperties));
        }
        return iter1;
    }
}

