/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.request;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.modify.request.Target;
import com.hp.hpl.jena.sparql.modify.request.UpdateAdd;
import com.hp.hpl.jena.sparql.modify.request.UpdateBinaryOp;
import com.hp.hpl.jena.sparql.modify.request.UpdateClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateCopy;
import com.hp.hpl.jena.sparql.modify.request.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataDelete;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataWriter;
import com.hp.hpl.jena.sparql.modify.request.UpdateDeleteWhere;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.sparql.modify.request.UpdateDropClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateLoad;
import com.hp.hpl.jena.sparql.modify.request.UpdateModify;
import com.hp.hpl.jena.sparql.modify.request.UpdateMove;
import com.hp.hpl.jena.sparql.modify.request.UpdateVisitor;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.PrologueSerializer;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.lib.Closeable;
import org.openjena.riot.out.SinkQuadBracedOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateWriter
implements Closeable {
    private final IndentedWriter out;
    private final SerializationContext sCxt;
    private UpdateDataWriter udw;
    private boolean firstOp = true;
    private boolean opened = false;

    public UpdateWriter(IndentedWriter out, SerializationContext sCxt) {
        if (out == null) {
            throw new IllegalArgumentException("out may not be null");
        }
        if (sCxt == null) {
            sCxt = new SerializationContext();
        }
        this.out = out;
        this.sCxt = sCxt;
    }

    public void open() {
        if (null != this.sCxt) {
            this.prologue();
        }
        this.opened = true;
    }

    private void checkOpen() {
        if (!this.opened) {
            throw new IllegalStateException("UpdateStreamWriter is not opened.  Call open() first.");
        }
    }

    private void prologue() {
        int row1 = this.out.getRow();
        PrologueSerializer.output(this.out, this.sCxt.getPrologue());
        int row2 = this.out.getRow();
        if (row1 != row2) {
            this.out.newline();
        }
    }

    private void prepareForDataUpdate(UpdateDataWriter.UpdateMode mode) {
        if (null != this.udw && !this.udw.getMode().equals((Object)mode)) {
            this.udw.close();
            this.udw = null;
            this.firstOp = false;
        }
        if (null == this.udw) {
            if (!this.firstOp) {
                this.out.println(" ;");
            }
            this.udw = new UpdateDataWriter(mode, this.out, this.sCxt);
            this.udw.open();
            this.firstOp = false;
        }
    }

    public void insert(Quad quad) {
        this.insert(quad.getGraph(), quad.asTriple());
    }

    public void insert(Iterator<? extends Quad> it) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.INSERT);
        while (it.hasNext()) {
            this.udw.send(it.next());
        }
    }

    public void insert(Node graph, Triple triple) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.INSERT);
        this.udw.send(graph, triple);
    }

    public void insert(Node graph, Iterator<? extends Triple> it) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.INSERT);
        while (it.hasNext()) {
            this.udw.send(graph, it.next());
        }
    }

    public void delete(Quad quad) {
        this.delete(quad.getGraph(), quad.asTriple());
    }

    public void delete(Iterator<? extends Quad> it) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.DELETE);
        while (it.hasNext()) {
            this.udw.send(it.next());
        }
    }

    public void delete(Node graph, Triple triple) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.DELETE);
        this.udw.send(graph, triple);
    }

    public void delete(Node graph, Iterator<? extends Triple> it) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.DELETE);
        while (it.hasNext()) {
            this.udw.send(graph, it.next());
        }
    }

    public void update(Update update2) {
        this.checkOpen();
        if (null != this.udw) {
            this.udw.close();
            this.udw = null;
        }
        if (!this.firstOp) {
            this.out.println(" ;");
        }
        Writer writer = new Writer(this.out, this.sCxt);
        update2.visit(writer);
        this.firstOp = false;
    }

    public void update(Iterable<? extends Update> updates) {
        this.update(updates.iterator());
    }

    public void update(Iterator<? extends Update> updateIter) {
        while (updateIter.hasNext()) {
            this.update(updateIter.next());
        }
    }

    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        if (this.opened) {
            if (null != this.udw) {
                this.udw.close();
                this.udw = null;
            }
            this.out.ensureStartOfLine();
            this.flush();
            this.opened = false;
        }
    }

    public static void output(UpdateRequest request, IndentedWriter out) {
        UpdateWriter.output(request, out, null);
    }

    public static void output(UpdateRequest request, IndentedWriter out, SerializationContext sCxt) {
        if (sCxt == null) {
            sCxt = new SerializationContext(request);
        }
        UpdateWriter uw = new UpdateWriter(out, sCxt);
        uw.open();
        uw.update(request);
        uw.close();
    }

    public static void output(Update update2, IndentedWriter out, SerializationContext sCxt) {
        if (sCxt == null) {
            sCxt = new SerializationContext();
        }
        UpdateWriter uw = new UpdateWriter(out, sCxt);
        uw.open();
        uw.update(update2);
        uw.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Writer
    implements UpdateVisitor {
        private static final int BLOCK_INDENT = 2;
        private final IndentedWriter out;
        private final SerializationContext sCxt;

        public Writer(IndentedWriter out, SerializationContext sCxt) {
            this.out = out;
            this.sCxt = sCxt;
        }

        private void visitDropClear(String name, UpdateDropClear update2) {
            this.out.ensureStartOfLine();
            this.out.print(name);
            this.out.print(" ");
            if (update2.isSilent()) {
                this.out.print("SILENT ");
            }
            this.printTarget(update2.getTarget());
        }

        private void printTarget(Target target) {
            if (target.isAll()) {
                this.out.print("ALL");
            } else if (target.isAllNamed()) {
                this.out.print("NAMED");
            } else if (target.isDefault()) {
                this.out.print("DEFAULT");
            } else if (target.isOneNamedGraph()) {
                this.out.print("GRAPH ");
                String s = FmtUtils.stringForNode(target.getGraph(), this.sCxt);
                this.out.print(s);
            } else {
                this.out.print("Target BROKEN");
                throw new ARQException("Malformed Target");
            }
        }

        @Override
        public void visit(UpdateDrop update2) {
            this.visitDropClear("DROP", update2);
        }

        @Override
        public void visit(UpdateClear update2) {
            this.visitDropClear("CLEAR", update2);
        }

        @Override
        public void visit(UpdateCreate update2) {
            this.out.ensureStartOfLine();
            this.out.print("CREATE");
            this.out.print(" ");
            if (update2.isSilent()) {
                this.out.print("SILENT ");
            }
            this.out.print("GRAPH");
            this.out.print(" ");
            String s = FmtUtils.stringForNode(update2.getGraph(), this.sCxt);
            this.out.print(s);
        }

        @Override
        public void visit(UpdateLoad update2) {
            this.out.ensureStartOfLine();
            this.out.print("LOAD");
            this.out.print(" ");
            if (update2.getSilent()) {
                this.out.print("SILENT ");
            }
            this.outputStringAsURI(update2.getSource());
            if (update2.getDest() != null) {
                this.out.print(" INTO GRAPH ");
                this.output(update2.getDest());
            }
        }

        private void outputStringAsURI(String uriStr) {
            String x = FmtUtils.stringForURI(uriStr, this.sCxt);
            this.out.print(x);
        }

        private void printTargetUpdate2(Target target) {
            if (target.isDefault()) {
                this.out.print("DEFAULT");
            } else if (target.isOneNamedGraph()) {
                String s = FmtUtils.stringForNode(target.getGraph(), this.sCxt);
                this.out.print(s);
            } else {
                this.out.print("Target BROKEN / Update2");
                throw new ARQException("Malformed Target / Update2");
            }
        }

        private void printUpdate2(UpdateBinaryOp update2, String name) {
            this.out.print(name);
            if (update2.getSilent()) {
                this.out.print(" SILENT");
            }
            this.out.print(" ");
            this.printTargetUpdate2(update2.getSrc());
            this.out.print(" TO ");
            this.printTargetUpdate2(update2.getDest());
        }

        @Override
        public void visit(UpdateAdd update2) {
            this.printUpdate2(update2, "ADD");
        }

        @Override
        public void visit(UpdateCopy update2) {
            this.printUpdate2(update2, "COPY");
        }

        @Override
        public void visit(UpdateMove update2) {
            this.printUpdate2(update2, "MOVE");
        }

        @Override
        public void visit(UpdateDataInsert update2) {
            UpdateDataWriter udw = new UpdateDataWriter(UpdateDataWriter.UpdateMode.INSERT, this.out, this.sCxt);
            udw.open();
            Iter.sendToSink(update2.getQuads(), udw);
        }

        @Override
        public void visit(UpdateDataDelete update2) {
            UpdateDataWriter udw = new UpdateDataWriter(UpdateDataWriter.UpdateMode.DELETE, this.out, this.sCxt);
            udw.open();
            Iter.sendToSink(update2.getQuads(), udw);
        }

        private void outputQuadsBraced(List<Quad> quads) {
            if (quads.size() == 0) {
                this.out.print("{ }");
                return;
            }
            SinkQuadBracedOutput sink = new SinkQuadBracedOutput(this.out, this.sCxt);
            sink.open();
            Iter.sendToSink(quads, sink);
        }

        private void output(Node node) {
            String $ = FmtUtils.stringForNode(node, this.sCxt);
            this.out.print($);
        }

        @Override
        public void visit(UpdateDeleteWhere update2) {
            this.out.ensureStartOfLine();
            this.out.println("DELETE WHERE ");
            this.outputQuadsBraced(update2.getQuads());
        }

        @Override
        public void visit(UpdateModify update2) {
            this.out.ensureStartOfLine();
            if (update2.getWithIRI() != null) {
                this.out.print("WITH ");
                this.output(update2.getWithIRI());
            }
            if (update2.hasDeleteClause()) {
                List<Quad> deleteQuads = update2.getDeleteQuads();
                this.out.ensureStartOfLine();
                this.out.print("DELETE ");
                this.outputQuadsBraced(deleteQuads);
            }
            if (update2.hasInsertClause()) {
                List<Quad> insertQuads = update2.getInsertQuads();
                this.out.ensureStartOfLine();
                this.out.print("INSERT ");
                this.outputQuadsBraced(insertQuads);
            }
            if (!update2.hasInsertClause() && !update2.hasDeleteClause()) {
                this.out.ensureStartOfLine();
                this.out.println("INSERT { }");
            }
            for (Node x : update2.getUsing()) {
                this.out.ensureStartOfLine();
                this.out.print("USING ");
                this.output(x);
            }
            for (Node x : update2.getUsingNamed()) {
                this.out.ensureStartOfLine();
                this.out.print("USING NAMED ");
                this.output(x);
            }
            Element el = update2.getWherePattern();
            this.out.ensureStartOfLine();
            this.out.print("WHERE");
            this.out.incIndent(2);
            this.out.newline();
            if (el != null) {
                FormatterElement fmtElement = new FormatterElement(this.out, this.sCxt);
                fmtElement.visitAsGroup(el);
            } else {
                this.out.print("{}");
            }
            this.out.decIndent(2);
        }
    }
}

