/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchIterator;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.openjena.atlas.data.DataBag;
import org.openjena.atlas.data.ThresholdPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphDataBag
extends GraphMemBase {
    private final ThresholdPolicy<Triple> thresholdPolicy;
    private DataBag<Triple> db;

    public GraphDataBag(ThresholdPolicy<Triple> thresholdPolicy) {
        this(thresholdPolicy, ReificationStyle.Minimal);
    }

    public GraphDataBag(ThresholdPolicy<Triple> thresholdPolicy, ReificationStyle style) {
        super(style);
        this.thresholdPolicy = thresholdPolicy;
        this.capabilities = new Capabilities(){

            public boolean sizeAccurate() {
                return false;
            }

            public boolean addAllowed() {
                return this.addAllowed(false);
            }

            public boolean addAllowed(boolean every) {
                return true;
            }

            public boolean deleteAllowed() {
                return this.deleteAllowed(false);
            }

            public boolean deleteAllowed(boolean every) {
                return false;
            }

            public boolean canBeEmpty() {
                return true;
            }

            public boolean iteratorRemoveAllowed() {
                return false;
            }

            public boolean findContractSafe() {
                return true;
            }

            public boolean handlesLiteralTyping() {
                return true;
            }
        };
        this.db = this.createDataBag();
    }

    protected abstract DataBag<Triple> createDataBag();

    protected ThresholdPolicy<Triple> getThresholdPolicy() {
        return this.thresholdPolicy;
    }

    protected TripleStore createTripleStore() {
        return null;
    }

    public void performAdd(Triple t) {
        if (!this.getReifier().handledAdd(t)) {
            this.db.add(t);
        }
    }

    public int graphBaseSize() {
        return (int)this.db.size();
    }

    protected void destroy() {
        this.db.close();
    }

    public void clear() {
        this.db.close();
        ((SimpleReifier)this.getReifier()).clear();
        this.db = this.createDataBag();
    }

    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        return new TripleMatchIterator(m.asTriple(), this.db.iterator());
    }
}

