/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.sparql.function.CastXSD;
import com.hp.hpl.jena.sparql.function.CastXSD_Boolean;
import com.hp.hpl.jena.sparql.function.CastXSD_DateTime;
import com.hp.hpl.jena.sparql.function.CastXSD_Numeric;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import com.hp.hpl.jena.sparql.function.library.FN_Abs;
import com.hp.hpl.jena.sparql.function.library.FN_BEV;
import com.hp.hpl.jena.sparql.function.library.FN_Ceiling;
import com.hp.hpl.jena.sparql.function.library.FN_Matches;
import com.hp.hpl.jena.sparql.function.library.FN_Not;
import com.hp.hpl.jena.sparql.function.library.FN_Round;
import com.hp.hpl.jena.sparql.function.library.FN_StrConcat;
import com.hp.hpl.jena.sparql.function.library.FN_StrContains;
import com.hp.hpl.jena.sparql.function.library.FN_StrEndsWith;
import com.hp.hpl.jena.sparql.function.library.FN_StrLength;
import com.hp.hpl.jena.sparql.function.library.FN_StrLowerCase;
import com.hp.hpl.jena.sparql.function.library.FN_StrStartsWith;
import com.hp.hpl.jena.sparql.function.library.FN_StrSubstring;
import com.hp.hpl.jena.sparql.function.library.FN_StrUpperCase;
import com.hp.hpl.jena.sparql.function.library.FN_floor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardFunctions {
    public static void loadStdDefs(FunctionRegistry registry) {
        String xfn = "http://www.w3.org/2005/xpath-functions#";
        String sparqlfn = "http://www.w3.org/sparqfn/";
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDdecimal);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDinteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDlong);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDint);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDshort);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDbyte);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDnonPositiveInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDnegativeInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDnonNegativeInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDpositiveInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDunsignedLong);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDunsignedInt);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDunsignedShort);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDdouble);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDfloat);
        StandardFunctions.addCastBoolean(registry, XSDDatatype.XSDboolean);
        StandardFunctions.addCast(registry, XSDDatatype.XSDduration);
        StandardFunctions.addCast(registry, XSDDatatype.XSDstring);
        StandardFunctions.addCast(registry, XSDDatatype.XSDanyURI);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDdateTime);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDdate);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDtime);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDgYear);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDgYearMonth);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDgMonth);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDgMonthDay);
        StandardFunctions.addCastDT(registry, XSDDatatype.XSDgDay);
        StandardFunctions.add(registry, xfn + "boolean", FN_BEV.class);
        StandardFunctions.add(registry, xfn + "not", FN_Not.class);
        StandardFunctions.add(registry, xfn + "matches", FN_Matches.class);
        StandardFunctions.add(registry, xfn + "string-length", FN_StrLength.class);
        StandardFunctions.add(registry, xfn + "concat", FN_StrConcat.class);
        StandardFunctions.add(registry, xfn + "substring", FN_StrSubstring.class);
        StandardFunctions.add(registry, xfn + "starts-with", FN_StrStartsWith.class);
        StandardFunctions.add(registry, xfn + "lower-case", FN_StrLowerCase.class);
        StandardFunctions.add(registry, xfn + "upper-case", FN_StrUpperCase.class);
        StandardFunctions.add(registry, xfn + "contains", FN_StrContains.class);
        StandardFunctions.add(registry, xfn + "ends-with", FN_StrEndsWith.class);
        StandardFunctions.add(registry, xfn + "abs", FN_Abs.class);
        StandardFunctions.add(registry, xfn + "ceiling", FN_Ceiling.class);
        StandardFunctions.add(registry, xfn + "floor", FN_floor.class);
        StandardFunctions.add(registry, xfn + "round", FN_Round.class);
    }

    private static void addCast(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new CastXSD(dt));
    }

    private static void addCastNumeric(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new CastXSD_Numeric(dt));
    }

    private static void addCastBoolean(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new CastXSD_Boolean(dt));
    }

    private static void addCastDT(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new CastXSD_DateTime(dt));
    }

    private static void add(FunctionRegistry registry, String uri, Class<?> funcClass) {
        registry.put(uri, funcClass);
    }
}

