/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class NodeValueDT
extends NodeValue {
    private static DatatypeFactory datatypefactory = null;
    private final XMLGregorianCalendar datetime;

    public NodeValueDT(String lex, Node n) {
        super(n);
        if (XSDDatatype.XSDgMonth.equals(this.getNode().getLiteralDatatype()) && lex.endsWith("Z")) {
            lex = lex.substring(0, lex.length() - 1);
            this.datetime = datatypefactory.newXMLGregorianCalendar(lex);
            this.datetime.setTimezone(0);
            return;
        }
        this.datetime = datatypefactory.newXMLGregorianCalendar(lex);
    }

    public boolean isDateTime() {
        return XSDDatatype.XSDdateTime.equals(this.getNode().getLiteralDatatype());
    }

    public boolean isDate() {
        return XSDDatatype.XSDdate.equals(this.getNode().getLiteralDatatype());
    }

    public boolean isTime() {
        return XSDDatatype.XSDtime.equals(this.getNode().getLiteralDatatype());
    }

    public boolean isGYear() {
        return XSDDatatype.XSDgYear.equals(this.getNode().getLiteralDatatype());
    }

    public boolean isGYearMonth() {
        return XSDDatatype.XSDgYearMonth.equals(this.getNode().getLiteralDatatype());
    }

    public boolean isGMonth() {
        return XSDDatatype.XSDgMonth.equals(this.getNode().getLiteralDatatype());
    }

    public boolean isGMonthDay() {
        return XSDDatatype.XSDgMonthDay.equals(this.getNode().getLiteralDatatype());
    }

    public boolean isGDay() {
        return XSDDatatype.XSDgDay.equals(this.getNode().getLiteralDatatype());
    }

    public XMLGregorianCalendar getDateTime() {
        return (XMLGregorianCalendar)this.datetime.clone();
    }

    protected Node makeNode() {
        return null;
    }

    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }

    static {
        try {
            datatypefactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new ARQInternalErrorException("Can't create a javax.xml DatatypeFactory");
        }
    }
}

