/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggSum
extends AggregatorBase {
    private static final NodeValue noValuesToSum = NodeValue.nvZERO;
    private Expr expr;

    public AggSum(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy(Expr expr) {
        return new AggSum(expr);
    }

    public String toString() {
        return "sum(" + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    public String toPrefixString() {
        return "(sum " + WriterExpr.asString(this.expr) + ")";
    }

    public Accumulator createAccumulator() {
        return new AccSum(this.expr);
    }

    public Expr getExpr() {
        return this.expr;
    }

    public Node getValueEmpty() {
        return null;
    }

    public int hashCode() {
        return 0x17C ^ this.expr.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggSum)) {
            return false;
        }
        AggSum agg = (AggSum)other;
        return agg.getExpr().equals(this.getExpr());
    }

    private static class AccSum
    extends AccumulatorExpr {
        private NodeValue total = null;

        public AccSum(Expr expr) {
            super(expr);
        }

        protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (nv.isNumber()) {
                this.total = this.total == null ? nv : XSDFuncOp.numAdd(nv, this.total);
            } else {
                throw new ExprEvalException("Not a number: " + nv);
            }
        }

        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        public NodeValue getAccValue() {
            return this.total;
        }
    }
}

