/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggAvg
extends AggregatorBase {
    private Expr expr;
    private static final NodeValue noValuesToAvg = NodeValue.nvZERO;

    public AggAvg(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy(Expr expr) {
        return new AggAvg(expr);
    }

    public String toString() {
        return "avg(" + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    public String toPrefixString() {
        return "(avg " + WriterExpr.asString(this.expr) + ")";
    }

    public Accumulator createAccumulator() {
        return new AccAvg(this.expr);
    }

    public final Expr getExpr() {
        return this.expr;
    }

    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToAvg);
    }

    public int hashCode() {
        return 0x170 ^ this.expr.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggAvg)) {
            return false;
        }
        AggAvg a = (AggAvg)other;
        return this.expr.equals(a.expr);
    }

    private static class AccAvg
    extends AccumulatorExpr {
        private NodeValue total = AggAvg.access$000();
        private int count = 0;
        static final boolean DEBUG = false;

        public AccAvg(Expr expr) {
            super(expr);
        }

        protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (nv.isNumber()) {
                ++this.count;
                this.total = this.total == noValuesToAvg ? nv : XSDFuncOp.numAdd(nv, this.total);
            } else {
                throw new ExprEvalException("avg: not a number: " + nv);
            }
        }

        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        public NodeValue getAccValue() {
            if (this.count == 0) {
                return noValuesToAvg;
            }
            if (this.errorCount != 0L) {
                return null;
            }
            NodeValue nvCount = NodeValue.makeInteger(this.count);
            return XSDFuncOp.numDivide(this.total, nvCount);
        }
    }
}

