/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.VarUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarFinder {
    VarUsageVisitor varUsageVisitor;

    public static Set<Var> optDefined(Op op) {
        return VarUsageVisitor.apply((Op)op).optDefines;
    }

    public static Set<Var> fixed(Op op) {
        return VarUsageVisitor.apply((Op)op).defines;
    }

    public static Set<Var> filter(Op op) {
        return VarUsageVisitor.apply((Op)op).filterMentions;
    }

    public VarFinder(Op op) {
        this.varUsageVisitor = VarUsageVisitor.apply(op);
    }

    public Set<Var> getOpt() {
        return this.varUsageVisitor.optDefines;
    }

    public Set<Var> getFilter() {
        return this.varUsageVisitor.filterMentions;
    }

    public Set<Var> getFixed() {
        return this.varUsageVisitor.defines;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VarUsageVisitor
    extends OpVisitorBase {
        Set<Var> defines = null;
        Set<Var> optDefines = null;
        Set<Var> filterMentions = null;

        static VarUsageVisitor apply(Op op) {
            VarUsageVisitor v = new VarUsageVisitor();
            op.visit(v);
            return v;
        }

        VarUsageVisitor() {
            this.defines = new HashSet<Var>();
            this.optDefines = new HashSet<Var>();
            this.filterMentions = new HashSet<Var>();
        }

        VarUsageVisitor(Set<Var> _defines, Set<Var> _optDefines, Set<Var> _filterMentions) {
            this.defines = _defines;
            this.optDefines = _optDefines;
            this.filterMentions = _filterMentions;
        }

        @Override
        public void visit(OpQuadPattern quadPattern) {
            VarUtils.addVar(this.defines, quadPattern.getGraphNode());
            BasicPattern triples = quadPattern.getBasicPattern();
            VarUtils.addVars(this.defines, triples);
        }

        @Override
        public void visit(OpBGP opBGP) {
            BasicPattern triples = opBGP.getPattern();
            VarUtils.addVars(this.defines, triples);
        }

        @Override
        public void visit(OpExt opExt) {
            opExt.effectiveOp().visit(this);
        }

        @Override
        public void visit(OpJoin opJoin) {
            this.joinAcc(opJoin.getLeft());
            this.joinAcc(opJoin.getRight());
        }

        @Override
        public void visit(OpSequence opSequence) {
            for (Op op : opSequence.getElements()) {
                this.joinAcc(op);
            }
        }

        private void joinAcc(Op op) {
            VarUsageVisitor usage = VarUsageVisitor.apply(op);
            this.defines.addAll(usage.defines);
            this.optDefines.addAll(usage.optDefines);
            this.filterMentions.addAll(usage.filterMentions);
        }

        @Override
        public void visit(OpLeftJoin opLeftJoin) {
            this.leftJoin(opLeftJoin.getLeft(), opLeftJoin.getRight(), opLeftJoin.getExprs());
        }

        @Override
        public void visit(OpConditional opLeftJoin) {
            this.leftJoin(opLeftJoin.getLeft(), opLeftJoin.getRight(), null);
        }

        private void leftJoin(Op left, Op right, ExprList exprs) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(left);
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(right);
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.optDefines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
            this.optDefines.removeAll(leftUsage.defines);
            if (exprs != null) {
                exprs.varsMentioned(this.filterMentions);
            }
        }

        @Override
        public void visit(OpUnion opUnion) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(opUnion.getLeft());
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(opUnion.getRight());
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.defines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
        }

        @Override
        public void visit(OpGraph opGraph) {
            VarUtils.addVar(this.defines, opGraph.getNode());
            opGraph.getSubOp().visit(this);
        }

        @Override
        public void visit(OpFilter opFilter) {
            opFilter.getExprs().varsMentioned(this.filterMentions);
            opFilter.getSubOp().visit(this);
        }

        @Override
        public void visit(OpAssign opAssign) {
            opAssign.getSubOp().visit(this);
            this.processVarExprList(opAssign.getVarExprList());
        }

        @Override
        public void visit(OpExtend opExtend) {
            opExtend.getSubOp().visit(this);
            this.processVarExprList(opExtend.getVarExprList());
        }

        private void processVarExprList(VarExprList varExprList) {
            Map<Var, Expr> map = varExprList.getExprs();
            for (Map.Entry<Var, Expr> e2 : map.entrySet()) {
                this.defines.add(e2.getKey());
                e2.getValue().varsMentioned(this.filterMentions);
            }
        }

        @Override
        public void visit(OpProject opProject) {
            List<Var> vars = opProject.getVars();
            VarUsageVisitor subUsage = VarUsageVisitor.apply(opProject.getSubOp());
            subUsage.defines.retainAll(vars);
            subUsage.optDefines.retainAll(vars);
            subUsage.optDefines.retainAll(vars);
            this.defines.addAll(subUsage.defines);
            this.optDefines.addAll(subUsage.optDefines);
            this.filterMentions.addAll(subUsage.filterMentions);
        }

        @Override
        public void visit(OpTable opTable) {
            this.defines.addAll(opTable.getTable().getVars());
        }

        @Override
        public void visit(OpNull opNull) {
        }
    }
}

