/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingComparator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.data.BagFactory;
import org.openjena.atlas.data.SortedDataBag;
import org.openjena.atlas.data.ThresholdPolicy;
import org.openjena.atlas.data.ThresholdPolicyFactory;
import org.openjena.atlas.iterator.IteratorDelayedInitialization;
import org.openjena.atlas.lib.Closeable;
import org.openjena.riot.SerializationFactoryFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryIterSort
extends QueryIterPlainWrapper {
    private final QueryIterator embeddedIterator;
    final SortedDataBag<Binding> db;

    public QueryIterSort(QueryIterator qIter, List<SortCondition> conditions, ExecutionContext context) {
        this(qIter, new BindingComparator(conditions, context), context);
    }

    public QueryIterSort(QueryIterator qIter, Comparator<Binding> comparator, ExecutionContext context) {
        super(null, context);
        this.embeddedIterator = qIter;
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(context.getContext());
        this.db = BagFactory.newSortedBag(policy, SerializationFactoryFinder.bindingSerializationFactory(), comparator);
        this.setIterator(new SortedBindingIterator(qIter));
    }

    @Override
    public void requestCancel() {
        this.embeddedIterator.cancel();
        super.requestCancel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortedBindingIterator
    extends IteratorDelayedInitialization<Binding>
    implements Closeable {
        private final QueryIterator qIter;

        public SortedBindingIterator(QueryIterator qIter) {
            this.qIter = qIter;
        }

        @Override
        protected Iterator<Binding> initializeIterator() {
            try {
                QueryIterSort.this.db.addAll(this.qIter);
            }
            catch (QueryCancelledException e2) {
                this.close();
                throw e2;
            }
            return QueryIterSort.this.db.iterator();
        }

        @Override
        public void close() {
            QueryIterSort.this.db.close();
        }
    }
}

