/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpQuad;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;

public class TransformPattern2Join
extends TransformCopy {
    public Op transform(OpBGP opBGP) {
        return TransformPattern2Join.expand(opBGP.getPattern());
    }

    public Op transform(OpQuadPattern quadPattern) {
        return TransformPattern2Join.expand(quadPattern.getPattern());
    }

    public static Op expand(BasicPattern bgp) {
        if (bgp.getList().isEmpty()) {
            return OpTable.unit();
        }
        Op op = null;
        for (Triple t : bgp.getList()) {
            OpTriple x = new OpTriple(t);
            op = TransformPattern2Join.join(op, x);
        }
        return op;
    }

    public static Op expand(QuadPattern quads) {
        if (quads.getList().isEmpty()) {
            return OpTable.unit();
        }
        Op op = null;
        for (Quad q : quads.getList()) {
            OpQuad x = new OpQuad(q);
            op = TransformPattern2Join.join(op, x);
        }
        return op;
    }

    private static Op join(Op left, Op right) {
        if (left == null || OpJoin.isJoinIdentify(left)) {
            return right;
        }
        if (right == null || OpJoin.isJoinIdentify(right)) {
            return left;
        }
        return OpJoin.create(left, right);
    }
}

