/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLabel;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpMinus;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpPropFunc;
import com.hp.hpl.jena.sparql.algebra.op.OpQuad;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpTopN;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprTransformCopy;
import com.hp.hpl.jena.sparql.expr.ExprTransformer;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementBind;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.util.graph.GraphList;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OpAsQuery {
    public static Query asQuery(Op op) {
        Query query2 = QueryFactory.make();
        Converter v = new Converter(query2);
        op.visit(v);
        List vars = v.projectVars;
        query2.setQueryResultStar(vars.isEmpty());
        for (Var var : vars) {
            if (v.varExpression.containsKey((Object)var)) {
                query2.addResultVar((Node)var, (Expr)v.varExpression.get((Object)var));
                continue;
            }
            query2.addResultVar((Node)var);
        }
        ElementGroup eg = v.currentGroup;
        query2.setQueryPattern(eg);
        query2.setQuerySelectType();
        query2.setResultVars();
        return query2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubExprForVar
    extends ExprTransformCopy {
        private final Map<Var, Expr> varExpr;
        private boolean subOccurred = false;

        public SubExprForVar(Map<Var, Expr> varExpr) {
            this.varExpr = varExpr;
        }

        public boolean didChange() {
            return this.subOccurred;
        }

        @Override
        public Expr transform(ExprVar var) {
            if (this.varExpr.containsKey((Object)var.asVar())) {
                this.subOccurred = true;
                return this.varExpr.get((Object)var.asVar()).deepCopy();
            }
            return var.deepCopy();
        }
    }

    public static class Converter
    implements OpVisitor {
        private Query query;
        private Element element = null;
        private ElementGroup currentGroup = null;
        private Deque<ElementGroup> stack = new ArrayDeque<ElementGroup>();
        private List<Var> projectVars = Collections.emptyList();
        private Map<Var, Expr> varExpression = new HashMap<Var, Expr>();

        public Converter(Query query2) {
            this.query = query2;
            this.currentGroup = new ElementGroup();
        }

        Element asElement(Op op) {
            ElementGroup g = this.asElementGroup(op);
            if (g.getElements().size() == 1) {
                return g.getElements().get(0);
            }
            return g;
        }

        ElementGroup asElementGroup(Op op) {
            this.startSubGroup();
            op.visit(this);
            return this.endSubGroup();
        }

        public void visit(OpBGP opBGP) {
            this.currentGroup().addElement(this.process(opBGP.getPattern()));
        }

        public void visit(OpTriple opTriple) {
            this.currentGroup().addElement(this.process(opTriple.getTriple()));
        }

        public void visit(OpQuad opQuad) {
            throw new ARQNotImplemented("OpQuad");
        }

        public void visit(OpProcedure opProcedure) {
            throw new ARQNotImplemented("OpProcedure");
        }

        public void visit(OpPropFunc opPropFunc) {
            Node s = this.processPropFuncArg(opPropFunc.getSubjectArgs());
            Node o = this.processPropFuncArg(opPropFunc.getObjectArgs());
            Triple t = new Triple(s, opPropFunc.getProperty(), o);
            this.currentGroup().addElement(this.process(t));
        }

        private Node processPropFuncArg(PropFuncArg args) {
            if (args.isNode()) {
                return args.getArg();
            }
            List<Node> list = args.getArgList();
            if (list.size() == 0) {
                return RDF.Nodes.nil;
            }
            BasicPattern bgp = new BasicPattern();
            Node head = GraphList.listToTriples(list, bgp);
            this.currentGroup().addElement(this.process(bgp));
            return head;
        }

        public void visit(OpSequence opSequence) {
            boolean nestGroup;
            ElementGroup g = this.currentGroup();
            boolean bl = nestGroup = !g.isEmpty();
            if (nestGroup) {
                this.startSubGroup();
                g = this.currentGroup();
            }
            Iterator<Op> iter = opSequence.iterator();
            while (iter.hasNext()) {
                Op op = iter.next();
                Element e2 = this.asElement(op);
                g.addElement(e2);
            }
            if (nestGroup) {
                this.endSubGroup();
            }
        }

        public void visit(OpDisjunction opDisjunction) {
            throw new ARQNotImplemented("OpDisjunction");
        }

        private Element process(BasicPattern pattern) {
            if (this.query.getSyntax() == Syntax.syntaxSPARQL_10) {
                ElementTriplesBlock e2 = new ElementTriplesBlock();
                for (Triple t : pattern) {
                    e2.addTriple(t);
                }
                return e2;
            }
            if (this.query.getSyntax() == Syntax.syntaxSPARQL_11 || this.query.getSyntax() == Syntax.syntaxARQ) {
                ElementPathBlock e3 = new ElementPathBlock();
                for (Triple t : pattern) {
                    e3.addTriple(t);
                }
                return e3;
            }
            throw new ARQInternalErrorException("Unrecognized syntax: " + this.query.getSyntax());
        }

        private ElementTriplesBlock process(Triple triple) {
            ElementTriplesBlock e2 = new ElementTriplesBlock();
            e2.addTriple(triple);
            return e2;
        }

        public void visit(OpQuadPattern quadPattern) {
            throw new ARQNotImplemented("OpQuadPattern");
        }

        public void visit(OpPath opPath) {
            throw new ARQNotImplemented("OpPath");
        }

        public void visit(OpJoin opJoin) {
            Element eLeft = this.asElement(opJoin.getLeft());
            ElementGroup eRight = this.asElementGroup(opJoin.getRight());
            ElementGroup g = this.currentGroup();
            g.addElement(eLeft);
            g.addElement(eRight);
        }

        private static boolean emptyGroup(Element element) {
            if (!(element instanceof ElementGroup)) {
                return false;
            }
            ElementGroup eg = (ElementGroup)element;
            return eg.isEmpty();
        }

        public void visit(OpLeftJoin opLeftJoin) {
            Element eLeft = this.asElement(opLeftJoin.getLeft());
            ElementGroup eRight = this.asElementGroup(opLeftJoin.getRight());
            if (opLeftJoin.getExprs() != null) {
                for (Expr expr : opLeftJoin.getExprs()) {
                    ElementFilter f = new ElementFilter(expr);
                    eRight.addElement(f);
                }
            }
            ElementGroup g = this.currentGroup();
            if (!Converter.emptyGroup(eLeft)) {
                g.addElement(eLeft);
            }
            ElementOptional opt = new ElementOptional(eRight);
            g.addElement(opt);
        }

        public void visit(OpDiff opDiff) {
            throw new ARQNotImplemented("OpDiff");
        }

        public void visit(OpMinus opMinus) {
            throw new ARQNotImplemented("OpMinus");
        }

        public void visit(OpUnion opUnion) {
            ElementGroup eLeft = this.asElementGroup(opUnion.getLeft());
            ElementGroup eRight = this.asElementGroup(opUnion.getRight());
            if (eLeft instanceof ElementUnion) {
                ElementUnion elUnion = (ElementUnion)((Object)eLeft);
                elUnion.addElement(eRight);
                return;
            }
            ElementUnion elUnion = new ElementUnion();
            elUnion.addElement(eLeft);
            elUnion.addElement(eRight);
            this.currentGroup().addElement(elUnion);
        }

        public void visit(OpConditional opCondition) {
            throw new ARQNotImplemented("OpCondition");
        }

        public void visit(OpFilter opFilter) {
            Element e2 = this.asElement(opFilter.getSubOp());
            if (this.currentGroup() != e2) {
                this.currentGroup().addElement(e2);
            }
            this.element = this.currentGroup();
            ExprList exprs = opFilter.getExprs();
            for (Expr expr : exprs) {
                ElementFilter f = new ElementFilter(expr);
                this.currentGroup().addElement(f);
            }
        }

        public void visit(OpGraph opGraph) {
            this.startSubGroup();
            Element e2 = this.asElement(opGraph.getSubOp());
            ElementGroup g = this.endSubGroup();
            ElementNamedGraph graphElt = new ElementNamedGraph(opGraph.getNode(), e2);
            this.currentGroup().addElement(graphElt);
        }

        public void visit(OpService opService) {
            Op op = opService.getSubOp();
            Element x = this.asElement(opService.getSubOp());
            ElementService elt = new ElementService(opService.getService(), x, opService.getSilent());
            this.currentGroup().addElement(elt);
        }

        public void visit(OpDatasetNames dsNames) {
            throw new ARQNotImplemented("OpDatasetNames");
        }

        public void visit(OpTable opTable) {
            if (opTable.isJoinIdentity()) {
                return;
            }
            throw new ARQNotImplemented("OpTable");
        }

        public void visit(OpExt opExt) {
            throw new ARQNotImplemented("OpExt");
        }

        public void visit(OpNull opNull) {
            throw new ARQNotImplemented("OpNull");
        }

        public void visit(OpLabel opLabel) {
            if (opLabel.hasSubOp()) {
                opLabel.getSubOp().visit(this);
            }
        }

        public void visit(OpAssign opAssign) {
            opAssign.getSubOp().visit(this);
            for (Var v : opAssign.getVarExprList().getVars()) {
                Expr e2 = opAssign.getVarExprList().getExpr(v);
                SubExprForVar sefr = new SubExprForVar(this.varExpression);
                Expr tr = ExprTransformer.transform((ExprTransform)sefr, e2);
                if (this.inTopLevel()) {
                    this.varExpression.put(v, tr);
                    continue;
                }
                ElementAssign elt = new ElementAssign(v, e2);
                ElementGroup g = this.currentGroup();
                g.addElement(elt);
            }
        }

        public void visit(OpExtend opExtend) {
            opExtend.getSubOp().visit(this);
            for (Var v : opExtend.getVarExprList().getVars()) {
                Expr e2 = opExtend.getVarExprList().getExpr(v);
                Expr tr = ExprTransformer.transform((ExprTransform)new SubExprForVar(this.varExpression), e2);
                if (this.inTopLevel()) {
                    this.varExpression.put(v, tr);
                    continue;
                }
                ElementBind elt = new ElementBind(v, tr);
                ElementGroup g = this.currentGroup();
                g.addElement(elt);
            }
        }

        public void visit(OpList opList) {
        }

        public void visit(OpOrder opOrder) {
            List<SortCondition> x = opOrder.getConditions();
            for (SortCondition sc : x) {
                this.query.addOrderBy(sc);
            }
            opOrder.getSubOp().visit(this);
        }

        public void visit(OpProject opProject) {
            this.projectVars = opProject.getVars();
            opProject.getSubOp().visit(this);
        }

        public void visit(OpReduced opReduced) {
            this.query.setReduced(true);
            opReduced.getSubOp().visit(this);
        }

        public void visit(OpDistinct opDistinct) {
            this.query.setDistinct(true);
            opDistinct.getSubOp().visit(this);
        }

        public void visit(OpSlice opSlice) {
            if (opSlice.getStart() != Long.MIN_VALUE) {
                this.query.setOffset(opSlice.getStart());
            }
            if (opSlice.getLength() != Long.MIN_VALUE) {
                this.query.setLimit(opSlice.getLength());
            }
            opSlice.getSubOp().visit(this);
        }

        public void visit(OpGroup opGroup) {
            List<ExprAggregator> a = opGroup.getAggregators();
            for (ExprAggregator ea : a) {
                Var givenVar = ea.getAggVar().asVar();
                Expr myAggr = this.query.allocAggregate(ea.getAggregator());
                this.varExpression.put(givenVar, myAggr);
            }
            VarExprList b = opGroup.getGroupVars();
            for (Var v : b.getVars()) {
                Expr e2 = b.getExpr(v);
                if (e2 != null) {
                    this.query.addGroupBy(v, e2);
                    continue;
                }
                this.query.addGroupBy((Node)v);
            }
            opGroup.getSubOp().visit(this);
        }

        public void visit(OpTopN opTop) {
            throw new ARQNotImplemented("OpTopN");
        }

        private Element lastElement() {
            ElementGroup g = this.currentGroup;
            if (g == null || g.getElements().size() == 0) {
                return null;
            }
            int len = g.getElements().size();
            return g.getElements().get(len - 1);
        }

        private void startSubGroup() {
            ElementGroup g;
            this.push(this.currentGroup);
            this.currentGroup = g = new ElementGroup();
        }

        private ElementGroup endSubGroup() {
            ElementGroup g = this.pop();
            ElementGroup r = this.currentGroup;
            this.currentGroup = g;
            return r;
        }

        private ElementGroup currentGroup() {
            return this.currentGroup;
        }

        private ElementGroup peek() {
            if (this.stack.size() == 0) {
                return null;
            }
            return this.stack.peek();
        }

        private ElementGroup pop() {
            return this.stack.pop();
        }

        private void push(ElementGroup el) {
            this.stack.push(el);
        }

        private boolean inTopLevel() {
            return this.stack.size() == 0;
        }
    }
}

