/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;
import java.util.List;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.IRILib;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.out.SinkQuadOutput;
import org.openjena.riot.pipeline.inf.InfFactory;
import org.openjena.riot.system.SinkExtendTriplesToQuads;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class infer
extends CmdGeneral {
    static final ArgDecl argRDFS = new ArgDecl(true, "rdfs");
    private Model vocab;

    public static void main(String ... argv) {
        new infer(argv).mainRun();
    }

    protected infer(String[] argv) {
        super(argv);
        super.add(argRDFS);
    }

    @Override
    protected String getSummary() {
        return "infer --rdfs=vocab FILE ...";
    }

    @Override
    protected void processModulesAndArgs() {
        if (!this.contains(argRDFS)) {
            throw new CmdException("Required argument missing: --" + argRDFS.getKeyName());
        }
        String fn = this.getValue(argRDFS);
        this.vocab = FileManager.get().loadModel(fn);
    }

    @Override
    protected void exec() {
        Sink<Quad> sink = new SinkQuadOutput(System.out);
        sink = InfFactory.infQuads(sink, this.vocab);
        List<String> files = this.getPositionalOrStdin();
        if (files.isEmpty()) {
            files.add("-");
        }
        for (String fn : files) {
            this.processFile(fn, sink);
        }
        IO.flush(System.out);
    }

    private void processFile(String filename, Sink<Quad> sink) {
        Lang lang = filename.equals("-") ? Lang.NQUADS : Lang.guess(filename, Lang.NQUADS);
        String baseURI = IRILib.filenameToIRI(filename);
        if (lang.isTriples()) {
            InputStream in = IO.openFile(filename);
            SinkExtendTriplesToQuads sink2 = new SinkExtendTriplesToQuads(sink);
            LangRIOT parser = RiotReader.createParserTriples(in, lang, baseURI, (Sink<Triple>)sink2);
            parser.parse();
            return;
        }
        InputStream in = IO.openFile(filename);
        LangRIOT parser = RiotReader.createParserQuads(in, lang, baseURI, sink);
        parser.parse();
    }

    @Override
    protected String getCommandName() {
        return "infer";
    }
}

