/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import arq.cmd.CmdException;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModLangParse;
import arq.cmdline.ModTime;
import com.hp.hpl.jena.Jena;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.SinkCounting;
import org.openjena.atlas.lib.SinkNull;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerFactory;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;
import org.openjena.riot.RiotReader;
import org.openjena.riot.SysRIOT;
import org.openjena.riot.lang.LangRDFXML;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.lang.LangTurtleBase;
import org.openjena.riot.out.NodeToLabel;
import org.openjena.riot.out.SinkQuadOutput;
import org.openjena.riot.out.SinkTripleOutput;
import org.openjena.riot.pipeline.inf.InfFactory;
import org.openjena.riot.pipeline.inf.InferenceSetupRDFS;
import org.openjena.riot.system.RiotLib;
import org.openjena.riot.system.SyntaxLabels;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public abstract class CmdLangParse
extends CmdGeneral {
    protected ModTime modTime = new ModTime();
    protected ModLangParse modLangParse = new ModLangParse();
    protected InferenceSetupRDFS setup = null;
    static LangHandler langHandlerQuads = new LangHandler(){

        public String getItemsName() {
            return "quads";
        }

        public String getRateName() {
            return "QPS";
        }
    };
    static LangHandler langHandlerTriples = new LangHandler(){

        public String getItemsName() {
            return "triples";
        }

        public String getRateName() {
            return "TPS";
        }
    };
    static LangHandler langHandlerAny = new LangHandler(){

        public String getItemsName() {
            return "tuples";
        }

        public String getRateName() {
            return "TPS";
        }
    };
    protected static Map<Lang, LangHandler> dispatch = new HashMap<Lang, LangHandler>();
    protected LangHandler langHandlerOverall = null;
    private static final String log4Jsetup;
    protected long totalMillis = 0L;
    protected long totalTuples = 0L;
    OutputStream output = System.out;

    public static void setLogging() {
        Properties p = new Properties();
        ByteArrayInputStream in = new ByteArrayInputStream(StrUtils.asUTF8bytes(log4Jsetup));
        try {
            p.load(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PropertyConfigurator.configure((Properties)p);
        System.setProperty("log4j.configuration", "set");
    }

    protected CmdLangParse(String[] argv) {
        super(argv);
        CmdLangParse.setLogging();
        super.addModule(this.modTime);
        super.addModule(this.modLangParse);
        this.modVersion.addClass(Jena.class);
        this.modVersion.addClass(ARQ.class);
    }

    protected String getSummary() {
        return this.getCommandName() + " [--time] [--check|--noCheck] [--sink] [--base=IRI] file ...";
    }

    protected void processModulesAndArgs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec() {
        if (this.modLangParse.strictMode()) {
            SysRIOT.StrictXSDLexicialForms = true;
            LangTurtleBase.strict = true;
        }
        if (this.modLangParse.getRDFSVocab() != null) {
            this.setup = new InferenceSetupRDFS(this.modLangParse.getRDFSVocab());
        }
        try {
            if (super.getPositional().isEmpty()) {
                this.parseFile("-");
            } else {
                for (String fn : super.getPositional()) {
                    this.parseFile(fn);
                }
            }
        }
        finally {
            System.err.flush();
            System.out.flush();
            if (super.getPositional().size() > 1 && this.modTime.timingEnabled()) {
                this.output("Total", this.totalTuples, this.totalMillis, this.langHandlerOverall);
            }
        }
    }

    public void parseFile(String filename) {
        InputStream in = null;
        if (filename.equals("-")) {
            this.parseFile("http://base/", "stdin", System.in);
        } else {
            try {
                in = IO.openFile(filename);
            }
            catch (Exception ex) {
                System.err.println("Can't open '" + filename + "' " + ex.getMessage());
                return;
            }
            this.parseFile(null, filename, in);
            IO.close(in);
        }
    }

    public void parseFile(String defaultBaseURI, String filename, InputStream in) {
        String baseURI = this.modLangParse.getBaseIRI();
        if (baseURI == null) {
            baseURI = defaultBaseURI;
        }
        this.parseRIOT(baseURI, filename, in);
    }

    protected abstract Lang selectLang(String var1, Lang var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRIOT(String baseURI, String filename, InputStream in) {
        SinkCounting<Triple> sink;
        LangRIOT parser;
        Sink<Object> s;
        Lang lang;
        LangHandler handler;
        baseURI = RiotReader.chooseBaseIRI(baseURI, filename);
        boolean checking = true;
        if (this.modLangParse.explicitChecking()) {
            checking = true;
        }
        if (this.modLangParse.explicitNoChecking()) {
            checking = false;
        }
        ErrorHandler errHandler = null;
        if (checking) {
            errHandler = this.modLangParse.stopOnBadTerm() ? ErrorHandlerFactory.errorHandlerStd : ErrorHandlerFactory.errorHandlerWarn;
        }
        if (this.modLangParse.skipOnBadTerm()) {
            // empty if block
        }
        if ((handler = dispatch.get((Object)(lang = this.selectLang(filename, Lang.NQUADS)))) == null) {
            throw new CmdException("Undefined language: " + (Object)((Object)lang));
        }
        if (this.langHandlerOverall == null) {
            this.langHandlerOverall = handler;
        } else if (this.langHandlerOverall != langHandlerAny && this.langHandlerOverall != handler) {
            this.langHandlerOverall = langHandlerAny;
        }
        boolean labelsAsGiven = false;
        NodeToLabel labels = SyntaxLabels.createNodeToLabel();
        if (lang.isTriples()) {
            s = SinkNull.create();
            if (!this.modLangParse.toBitBucket()) {
                s = new SinkTripleOutput(this.output, null, labels);
            }
            if (this.setup != null) {
                s = InfFactory.infTriples(s, this.setup);
            }
            SinkCounting<Triple> sink2 = new SinkCounting<Triple>(s);
            parser = lang.equals((Object)Lang.RDFXML) ? LangRDFXML.create(in, baseURI, filename, errHandler, sink2) : RiotReader.createParserTriples(in, lang, baseURI, sink2);
            sink = sink2;
        } else {
            s = SinkNull.create();
            if (!this.modLangParse.toBitBucket()) {
                s = new SinkQuadOutput(this.output, null, labels);
            }
            if (this.setup != null) {
                s = InfFactory.infQuads(s, this.setup);
            }
            SinkCounting<Triple> sink2 = new SinkCounting<Triple>(s);
            parser = RiotReader.createParserQuads(in, lang, baseURI, sink2);
            sink = sink2;
        }
        try {
            if (checking) {
                if (parser.getLang() == Lang.NTRIPLES || parser.getLang() == Lang.NQUADS) {
                    parser.setProfile(RiotLib.profile(baseURI, false, true, errHandler));
                } else {
                    parser.setProfile(RiotLib.profile(baseURI, true, true, errHandler));
                }
            } else {
                parser.setProfile(RiotLib.profile(baseURI, false, false, errHandler));
            }
            this.modTime.startTimer();
            parser.parse();
        }
        catch (RiotException ex) {
            if (this.modLangParse.stopOnBadTerm()) {
                return;
            }
        }
        finally {
            IO.close(in);
            sink.flush();
        }
        long x = this.modTime.endTimer();
        long n = sink.getCount();
        if (this.modTime.timingEnabled()) {
            this.output(filename, n, x, handler);
        }
        this.totalMillis += x;
        this.totalTuples += n;
    }

    protected Tokenizer makeTokenizer(InputStream in) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(in);
        return tokenizer;
    }

    protected void output(String label, long numberTriples, long timeMillis, LangHandler handler) {
        double timeSec = (double)timeMillis / 1000.0;
        System.out.flush();
        System.err.printf("%s : %,5.2f sec  %,d %s  %,.2f %s\n", label, (double)timeMillis / 1000.0, numberTriples, handler.getItemsName(), timeSec == 0.0 ? 0.0 : (double)numberTriples / timeSec, handler.getRateName());
    }

    protected void output(String label) {
        System.err.printf("%s : \n", label);
    }

    static {
        for (Lang lang : Lang.values()) {
            if (lang.isQuads()) {
                dispatch.put(lang, langHandlerQuads);
                continue;
            }
            dispatch.put(lang, langHandlerTriples);
        }
        log4Jsetup = StrUtils.strjoin("\n", "## Plain output to stderr", "log4j.appender.riot.plainerr=org.apache.log4j.ConsoleAppender", "log4j.appender.riot.plainerr.target=System.err", "log4j.appender.riot.plainerr.layout=org.apache.log4j.PatternLayout", "log4j.appender.riot.plainerr.layout.ConversionPattern=%-5p %m%n", "## Everything", "log4j.rootLogger=INFO, riot.plainerr", "## Parser output", "log4j.additivity.org.openjena.riot=false", "log4j.logger.org.openjena.riot=ALL, riot.plainerr ");
    }

    static interface LangHandler {
        public String getItemsName();

        public String getRateName();
    }
}

