/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.io.OutputStream;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.Lib;
import org.openjena.atlas.lib.Sink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinkQuadBracedOutput
implements Sink<Quad>,
Closeable {
    protected static final int BLOCK_INDENT = 2;
    protected final IndentedWriter out;
    protected final SerializationContext sCxt;
    protected boolean opened = false;
    protected Node currentGraph;

    public SinkQuadBracedOutput(OutputStream out) {
        this(out, null);
    }

    public SinkQuadBracedOutput(OutputStream out, SerializationContext sCxt) {
        this(new IndentedWriter(out), sCxt);
    }

    public SinkQuadBracedOutput(IndentedWriter out, SerializationContext sCxt) {
        if (out == null) {
            throw new IllegalArgumentException("out may not be null");
        }
        if (sCxt == null) {
            sCxt = new SerializationContext();
        }
        this.out = out;
        this.sCxt = sCxt;
    }

    public void open() {
        this.out.println("{");
        this.out.incIndent(2);
        this.opened = true;
    }

    private void checkOpen() {
        if (!this.opened) {
            throw new IllegalStateException("SinkQuadBracedOutput is not opened.  Call open() first.");
        }
    }

    @Override
    public void send(Quad quad) {
        this.send(quad.getGraph(), quad.asTriple());
    }

    public void send(Node graphName, Triple triple) {
        this.checkOpen();
        if (Quad.isDefaultGraph(graphName)) {
            graphName = null;
        }
        if (!Lib.equal(this.currentGraph, graphName)) {
            if (null != this.currentGraph) {
                this.out.decIndent(2);
                this.out.println("}");
            }
            if (null != graphName) {
                this.out.print("GRAPH ");
                this.output(graphName);
                this.out.println(" {");
                this.out.incIndent(2);
            }
        }
        this.output(triple);
        this.out.println(" .");
        this.currentGraph = graphName;
    }

    private void output(Node node) {
        String n = FmtUtils.stringForNode(node, this.sCxt);
        this.out.print(n);
    }

    private void output(Triple triple) {
        String s = FmtUtils.stringForNode(triple.getSubject(), this.sCxt);
        String p = FmtUtils.stringForNode(triple.getPredicate(), this.sCxt);
        String o = FmtUtils.stringForNode(triple.getObject(), this.sCxt);
        this.out.print(s);
        this.out.print(" ");
        this.out.print(p);
        this.out.print(" ");
        this.out.print(o);
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        if (this.opened) {
            if (null != this.currentGraph) {
                this.out.decIndent(2);
                this.out.println("}");
            }
            this.out.decIndent(2);
            this.out.print("}");
            this.flush();
            this.opened = false;
        }
    }
}

