/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.SinkToQueue;
import org.openjena.riot.Lang;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.system.ParserProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RiotParsePuller<T>
implements Iterator<T>,
Closeable,
LangRIOT {
    private static final int QUEUE_CAPACITY = 1000;
    private static final int ITERATOR_POLL_TIMEOUT = 1000;
    private static final TimeUnit ITERATOR_POLL_TIMEUNIT = TimeUnit.MILLISECONDS;
    protected final InputStream in;
    protected final Lang lang;
    protected final String baseIRI;
    protected final LangRIOT parser;
    private final BlockingQueue<T> queue;
    private final T endMarker = new Object();
    private Thread readThread;
    private volatile RuntimeException uncaughtException;
    private boolean finished;
    private T slot;

    public RiotParsePuller(InputStream in, Lang lang, String baseIRI) {
        this.in = in;
        this.lang = lang;
        this.baseIRI = baseIRI;
        this.queue = new ArrayBlockingQueue<T>(1000);
        SinkToQueue<T> sink = new SinkToQueue<T>(this.queue);
        this.parser = this.createParser(sink);
    }

    @Override
    public Lang getLang() {
        return this.lang;
    }

    @Override
    public ParserProfile getProfile() {
        return this.parser.getProfile();
    }

    @Override
    public void setProfile(ParserProfile profile) {
        this.parser.setProfile(profile);
    }

    protected abstract LangRIOT createParser(Sink<T> var1);

    @Override
    public void parse() {
        this.readThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean noExceptions = true;
                try {
                    RiotParsePuller.this.parser.parse();
                }
                catch (RuntimeException e2) {
                    RiotParsePuller.this.uncaughtException = e2;
                    noExceptions = false;
                }
                finally {
                    if (noExceptions) {
                        try {
                            RiotParsePuller.this.queue.put(RiotParsePuller.this.endMarker);
                        }
                        catch (InterruptedException e3) {
                            RiotParsePuller.this.uncaughtException = new CancellationException();
                        }
                    }
                    try {
                        RiotParsePuller.this.in.close();
                    }
                    catch (IOException e4) {
                        RiotParsePuller.this.uncaughtException = new AtlasException("Error closing input stream", e4);
                    }
                }
            }
        });
        this.readThread.start();
    }

    @Override
    public void close() {
        if (null != this.readThread) {
            this.readThread.interrupt();
        }
    }

    @Override
    public boolean hasNext() {
        block7: {
            if (this.finished) {
                return false;
            }
            if (this.slot != null) {
                return true;
            }
            do {
                try {
                    this.slot = this.queue.poll(1000L, ITERATOR_POLL_TIMEUNIT);
                }
                catch (InterruptedException e2) {
                    return false;
                }
                if (null != this.slot) break block7;
            } while (null == this.uncaughtException);
            this.finished = true;
            if (this.uncaughtException instanceof CancellationException) {
                return false;
            }
            throw this.uncaughtException;
        }
        if (this.slot == this.endMarker) {
            this.finished = true;
            this.slot = null;
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T item = this.slot;
        this.slot = null;
        return item;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

