/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import org.openjena.atlas.lib.Cache;
import org.openjena.atlas.lib.CacheSet;
import org.openjena.atlas.lib.CacheStats;
import org.openjena.atlas.lib.cache.Cache0;
import org.openjena.atlas.lib.cache.Cache1;
import org.openjena.atlas.lib.cache.CacheLRU;
import org.openjena.atlas.lib.cache.CacheSetLRU;
import org.openjena.atlas.lib.cache.CacheSetSync;
import org.openjena.atlas.lib.cache.CacheSimple;
import org.openjena.atlas.lib.cache.CacheStatsAtomic;
import org.openjena.atlas.lib.cache.CacheSync;
import org.openjena.atlas.lib.cache.CacheUnbounded;
import org.openjena.atlas.lib.cache.CacheWithGetter;
import org.openjena.atlas.lib.cache.Getter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheFactory {
    public static <Key, Value> Cache<Key, Value> createCache(int maxSize) {
        return CacheFactory.createCache(0.75f, maxSize);
    }

    public static <Key, Value> Cache<Key, Value> createCache(float loadFactor, int maxSize) {
        return new CacheLRU(0.75f, maxSize);
    }

    public static <Key, Value> Cache<Key, Value> createCache(Getter<Key, Value> getter, int maxSize) {
        Cache<Key, Value> cache = CacheFactory.createCache(0.75f, maxSize);
        return CacheFactory.createCacheWithGetter(cache, getter);
    }

    public static <Key, Value> Cache<Key, Value> createNullCache() {
        return new Cache0();
    }

    public static <Key, Value> Cache<Key, Value> createCacheUnbounded() {
        return new CacheUnbounded();
    }

    public static <Key, Value> Cache<Key, Value> createCacheWithGetter(Cache<Key, Value> cache, Getter<Key, Value> getter) {
        return new CacheWithGetter<Key, Value>(cache, getter);
    }

    public static <Key, Value> Cache<Key, Value> createSimpleCache(int size) {
        return new CacheSimple(size);
    }

    public static <Key, Value> Cache<Key, Value> createOneSlotCache() {
        return new Cache1();
    }

    public static <Key, Value> CacheStats<Key, Value> createStats(Cache<Key, Value> cache) {
        if (cache instanceof CacheStats) {
            return (CacheStats)cache;
        }
        return new CacheStatsAtomic<Key, Value>(cache);
    }

    public static <Key, Value> Cache<Key, Value> createSync(Cache<Key, Value> cache) {
        if (cache instanceof CacheSync) {
            return cache;
        }
        return new CacheSync<Key, Value>(cache);
    }

    public static <Obj> CacheSet<Obj> createCacheSet(int size) {
        return new CacheSetLRU(size);
    }

    public static <Obj> CacheSet<Obj> createSync(CacheSet<Obj> cache) {
        if (cache instanceof CacheSetSync) {
            return cache;
        }
        return new CacheSetSync<Obj>(cache);
    }
}

