/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json.io.parser;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.io.PeekReader;
import org.openjena.atlas.json.JsonParseException;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;

public class TokenizerJSON
implements Tokenizer {
    public static final int CTRL_CHAR = 42;
    private Token token = null;
    private final StringBuilder sb = new StringBuilder();
    private final PeekReader reader;
    private boolean finished = false;

    public TokenizerJSON(PeekReader reader) {
        this.reader = reader;
    }

    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.token != null) {
            return true;
        }
        this.skip();
        if (this.reader.eof()) {
            return false;
        }
        this.token = this.parseToken();
        return this.token != null;
    }

    public final boolean eof() {
        return this.hasNext();
    }

    public final Token next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Token t = this.token;
        this.token = null;
        return t;
    }

    public final Token peek() {
        if (!this.hasNext()) {
            return null;
        }
        return this.token;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Token parseToken() {
        this.token = new Token(this.getLine(), this.getColumn());
        int ch = this.reader.peekChar();
        if (ch == 39 || ch == 34) {
            this.reader.readChar();
            int ch2 = this.reader.peekChar();
            if (ch2 == ch) {
                this.reader.readChar();
                int ch3 = this.reader.peekChar();
                if (ch3 == ch) {
                    this.reader.readChar();
                    this.token.setImage(this.readLong(ch, false));
                    TokenType tt = ch == 39 ? TokenType.LONG_STRING1 : TokenType.LONG_STRING2;
                    this.token.setType(tt);
                    return this.token;
                }
                this.token.setImage("");
            } else {
                this.token.setImage(this.allBetween(ch, ch, true, false));
            }
            this.token.setType(ch == 39 ? TokenType.STRING1 : TokenType.STRING2);
            return this.token;
        }
        if (ch == 42) {
            this.reader.readChar();
            this.token.setType(TokenType.CNTRL);
            ch = this.reader.readChar();
            if (ch == -1) {
                this.exception("EOF found after 42");
            }
            this.token.cntrlCode = (char)ch;
            return this.token;
        }
        switch (ch) {
            case 46: {
                this.token.setType(TokenType.DOT);
                return this.token;
            }
            case 59: {
                this.reader.readChar();
                this.token.setType(TokenType.SEMICOLON);
                return this.token;
            }
            case 44: {
                this.reader.readChar();
                this.token.setType(TokenType.COMMA);
                return this.token;
            }
            case 123: {
                this.reader.readChar();
                this.token.setType(TokenType.LBRACE);
                return this.token;
            }
            case 125: {
                this.reader.readChar();
                this.token.setType(TokenType.RBRACE);
                return this.token;
            }
            case 40: {
                this.reader.readChar();
                this.token.setType(TokenType.LPAREN);
                return this.token;
            }
            case 41: {
                this.reader.readChar();
                this.token.setType(TokenType.RPAREN);
                return this.token;
            }
            case 91: {
                this.reader.readChar();
                this.token.setType(TokenType.LBRACKET);
                return this.token;
            }
            case 93: {
                this.reader.readChar();
                this.token.setType(TokenType.RBRACKET);
                return this.token;
            }
            case 58: {
                this.reader.readChar();
                this.token.setType(TokenType.COLON);
                return this.token;
            }
            case 60: {
                this.reader.readChar();
                this.token.setType(TokenType.LT);
                return this.token;
            }
            case 62: {
                this.reader.readChar();
                this.token.setType(TokenType.GT);
                return this.token;
            }
        }
        if (ch == 43 || ch == 45 || TokenizerJSON.range(ch, '0', '9')) {
            this.readNumber();
            return this.token;
        }
        this.readKeyWord(this.token);
        return this.token;
    }

    private void skip() {
        int ch = -1;
        while (true) {
            if (this.reader.eof()) {
                return;
            }
            ch = this.reader.peekChar();
            if (ch == 35) {
                this.reader.readChar();
                while ((ch = this.reader.peekChar()) != -1 && !TokenizerJSON.isNewlineChar(ch)) {
                    this.reader.readChar();
                }
            }
            if (!TokenizerJSON.isWhitespace(ch)) break;
            this.reader.readChar();
        }
    }

    private void readKeyWord(Token token2) {
        long posn = this.reader.getPosition();
        token2.setImage(this.readWord(false));
        token2.setType(TokenType.KEYWORD);
        int ch = this.reader.peekChar();
        if (posn == this.reader.getPosition()) {
            this.exception(String.format("Unknown char: %c(%d)", ch, ch));
        }
    }

    private String readLong(int quoteChar, boolean endNL) {
        this.sb.setLength(0);
        while (true) {
            int ch;
            if ((ch = this.reader.readChar()) == -1) {
                if (endNL) {
                    return this.sb.toString();
                }
                this.exception("Broken long string");
            }
            if (ch == quoteChar && this.threeQuotes(quoteChar)) {
                return this.sb.toString();
            }
            if (ch == 92) {
                ch = this.readLiteralEscape();
            }
            this.insertLiteralChar(this.sb, ch);
        }
    }

    private boolean threeQuotes(int ch) {
        int ch2 = this.reader.peekChar();
        if (ch2 != ch) {
            return false;
        }
        this.reader.readChar();
        int ch3 = this.reader.peekChar();
        if (ch3 != ch) {
            this.reader.pushbackChar(ch2);
            return false;
        }
        this.reader.readChar();
        return true;
    }

    private String readWord(boolean leadingDigitAllowed) {
        int ch;
        this.sb.setLength(0);
        int idx = 0;
        if (!leadingDigitAllowed && Character.isDigit(ch = this.reader.peekChar())) {
            return "";
        }
        while (Character.isLetterOrDigit(ch = this.reader.peekChar()) || ch == 95 || ch == 46 || ch == 45) {
            this.reader.readChar();
            this.sb.append((char)ch);
            ++idx;
        }
        return this.sb.toString();
    }

    private void readNumber() {
        boolean isDouble = false;
        boolean isDecimal = false;
        this.sb.setLength(0);
        int x = 0;
        int ch = this.reader.peekChar();
        if (ch == 48) {
            ++x;
            this.reader.readChar();
            this.sb.append((char)ch);
            ch = this.reader.peekChar();
            if (ch == 120 || ch == 88) {
                this.reader.readChar();
                this.sb.append((char)ch);
                TokenizerJSON.readHex(this.reader, this.sb);
                this.token.setImage(this.sb.toString());
                this.token.setType(TokenType.HEX);
                return;
            }
        } else if (ch == 45 || ch == 43) {
            this.readPossibleSign(this.sb);
        }
        x += this.readDigits(this.sb);
        ch = this.reader.peekChar();
        if (ch == 46) {
            this.reader.readChar();
            this.sb.append('.');
            isDecimal = true;
            this.readDigits(this.sb);
        }
        if (x == 0 && !isDecimal) {
            this.exception("Unrecognized as number");
        }
        if (this.exponent(this.sb)) {
            isDouble = true;
            isDecimal = false;
        }
        this.token.setImage(this.sb.toString());
        if (isDouble) {
            this.token.setType(TokenType.DOUBLE);
        } else if (isDecimal) {
            this.token.setType(TokenType.DECIMAL);
        } else {
            this.token.setType(TokenType.INTEGER);
        }
    }

    private static void readHex(PeekReader reader, StringBuilder sb) {
        int ch;
        int x = 0;
        while (TokenizerJSON.range(ch = reader.peekChar(), '0', '9') || TokenizerJSON.range(ch, 'a', 'f') || TokenizerJSON.range(ch, 'A', 'F')) {
            reader.readChar();
            sb.append((char)ch);
            ++x;
        }
        if (x == 0) {
            TokenizerJSON.exception(reader, "No hex characters after " + sb.toString());
        }
    }

    private boolean exponent(StringBuilder sb) {
        int ch = this.reader.peekChar();
        if (ch != 101 && ch != 69) {
            return false;
        }
        this.reader.readChar();
        sb.append((char)ch);
        this.readPossibleSign(sb);
        int x = this.readDigits(sb);
        if (x == 0) {
            this.exception("Malformed double: " + sb);
        }
        return true;
    }

    private void readPossibleSign(StringBuilder sb) {
        int ch = this.reader.peekChar();
        if (ch == 45 || ch == 43) {
            this.reader.readChar();
            sb.append((char)ch);
        }
    }

    private int readDigits(StringBuilder buffer) {
        int ch;
        int count = 0;
        while (TokenizerJSON.range(ch = this.reader.peekChar(), '0', '9')) {
            this.reader.readChar();
            buffer.append((char)ch);
            ++count;
        }
        return count;
    }

    private String langTag() {
        int ch;
        this.sb.setLength(0);
        this.a2z(this.sb);
        if (this.sb.length() == 0) {
            this.exception("Bad language tag");
        }
        while ((ch = this.reader.peekChar()) == 45) {
            this.reader.readChar();
            this.sb.append('-');
            int x = this.sb.length();
            this.a2zN(this.sb);
            if (this.sb.length() != x) continue;
            this.exception("Bad language tag");
        }
        return this.sb.toString();
    }

    private void a2z(StringBuilder sb2) {
        int ch;
        while (this.isA2Z(ch = this.reader.peekChar())) {
            this.reader.readChar();
            this.sb.append((char)ch);
        }
    }

    private void a2zN(StringBuilder sb2) {
        int ch;
        while (this.isA2ZN(ch = this.reader.peekChar())) {
            this.reader.readChar();
            this.sb.append((char)ch);
        }
    }

    private String blankNodeLabel() {
        int ch;
        this.sb.setLength(0);
        boolean seen = false;
        while ((ch = this.reader.readChar()) != -1 && (this.isA2ZN(ch) || ch == 45)) {
            this.sb.append((char)ch);
            seen = true;
        }
        if (!seen) {
            this.exception("Blank node label missing");
        }
        return this.sb.toString();
    }

    private String allBetween(int startCh, int endCh, boolean strEscapes, boolean endNL) {
        long y = this.getLine();
        long x = this.getColumn();
        this.sb.setLength(0);
        while (true) {
            int ch;
            if ((ch = this.reader.readChar()) == -1) {
                if (endNL) {
                    return this.sb.toString();
                }
                TokenizerJSON.exception("Broken token: " + this.sb.toString(), y, x);
            }
            if (ch == 10) {
                TokenizerJSON.exception("Broken token (newline): " + this.sb.toString(), y, x);
            }
            if (ch == endCh) {
                return this.sb.toString();
            }
            if (ch == 92) {
                if (strEscapes) {
                    ch = this.readLiteralEscape();
                } else {
                    ch = this.reader.readChar();
                    if (ch == -1) {
                        if (endNL) {
                            return this.sb.toString();
                        }
                        TokenizerJSON.exception("Broken token: " + this.sb.toString(), y, x);
                    }
                    switch (ch) {
                        case 117: {
                            ch = this.readUnicode4Escape();
                            break;
                        }
                        case 85: {
                            ch = this.readUnicode4Escape();
                            break;
                        }
                        default: {
                            this.exception(String.format("illegal escape sequence value: %c (0x%02X)", ch, ch));
                        }
                    }
                }
            }
            this.insertLiteralChar(this.sb, ch);
        }
    }

    private void insertLiteralChar(StringBuilder buffer, int ch) {
        if (Character.charCount(ch) == 1) {
            buffer.append((char)ch);
        } else {
            if (!Character.isDefined(ch) && !Character.isSupplementaryCodePoint(ch)) {
                this.exception(String.format("Illegal codepoint: 0x%04X", ch));
            }
            char[] chars = Character.toChars(ch);
            buffer.append(chars);
        }
    }

    public long getColumn() {
        return this.reader.getColNum();
    }

    public long getLine() {
        return this.reader.getLineNum();
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private boolean isA2Z(int ch) {
        return TokenizerJSON.range(ch, 'a', 'z') || TokenizerJSON.range(ch, 'A', 'Z');
    }

    private boolean isA2ZN(int ch) {
        return TokenizerJSON.range(ch, 'a', 'z') || TokenizerJSON.range(ch, 'A', 'Z') || TokenizerJSON.range(ch, '0', '9');
    }

    private boolean isNumeric(int ch) {
        return TokenizerJSON.range(ch, '0', '9');
    }

    private static boolean isWhitespace(int ch) {
        return ch == 32 || ch == 9 || ch == 13 || ch == 10 || ch == 12;
    }

    private static boolean isNewlineChar(int ch) {
        return ch == 13 || ch == 10;
    }

    private final int readLiteralEscape() {
        int c = this.reader.readChar();
        if (c == -1) {
            this.exception("Escape sequence not completed");
        }
        switch (c) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 34: {
                return 34;
            }
            case 47: {
                return 47;
            }
            case 39: {
                return 39;
            }
            case 92: {
                return 92;
            }
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.exception(String.format("illegal escape sequence value: %c (0x%02X)", c, c));
        return 0;
    }

    private final int readUnicodeEscape() {
        int ch = this.reader.readChar();
        if (ch == -1) {
            this.exception("Broken escape sequence");
        }
        switch (ch) {
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.exception(String.format("illegal escape sequence value: %c (0x%02X)", ch, ch));
        return 0;
    }

    private final int readUnicode4Escape() {
        return this.readUnicodeEscape(4);
    }

    private final int readUnicode8Escape() {
        int ch8 = this.readUnicodeEscape(8);
        if (ch8 > 0x10FFFF) {
            this.exception(String.format("illegal code point in \\U sequence value: 0x%08X", ch8));
        }
        return ch8;
    }

    private final int readUnicodeEscape(int N) {
        int x = 0;
        for (int i = 0; i < N; ++i) {
            int d = this.readHexChar();
            if (d < 0) {
                return -1;
            }
            x = (x << 4) + d;
        }
        return x;
    }

    private final int readHexChar() {
        int ch = this.reader.readChar();
        if (ch == -1) {
            this.exception("Not a hexadecimal character (end of file)");
        }
        if (TokenizerJSON.range(ch, '0', '9')) {
            return ch - 48;
        }
        if (TokenizerJSON.range(ch, 'a', 'f')) {
            return ch - 97 + 10;
        }
        if (TokenizerJSON.range(ch, 'A', 'F')) {
            return ch - 65 + 10;
        }
        this.exception("Not a hexadecimal character: " + (char)ch);
        return -1;
    }

    private static boolean range(int ch, char a, char b) {
        return ch >= a && ch <= b;
    }

    private boolean expect(String str2) {
        for (int i = 0; i < str2.length(); ++i) {
            char want = str2.charAt(i);
            if (this.reader.eof()) {
                this.exception("End of input during expected string: " + str2);
                return false;
            }
            int inChar = this.reader.readChar();
            if (inChar == want) continue;
            this.exception("expected \"" + str2 + "\"");
            return false;
        }
        return true;
    }

    private void exception(String message) {
        TokenizerJSON.exception(message, this.reader.getLineNum(), this.reader.getColNum());
    }

    private static void exception(PeekReader reader, String message) {
        TokenizerJSON.exception(message, reader.getLineNum(), reader.getColNum());
    }

    private static void exception(String message, long line, long col) {
        throw new JsonParseException(message, (int)line, (int)col);
    }
}

