/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import java.io.Closeable;
import java.util.Iterator;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.iterator.Iter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorResourceClosing<T>
implements Iterator<T>,
org.openjena.atlas.lib.Closeable {
    private final Iterator<T> iter;
    private final Object resource;
    private boolean finished;

    public IteratorResourceClosing(Iterator<T> iter, org.openjena.atlas.lib.Closeable resource) {
        this.iter = iter;
        this.resource = resource;
        this.finished = false;
    }

    public IteratorResourceClosing(Iterator<T> iter, Closeable resource) {
        this.iter = iter;
        this.resource = resource;
        this.finished = false;
    }

    private void checkFinished() {
        if (this.finished) {
            throw new AtlasException("IteratorResourceClosing is closed, no further operations can be performed on it.");
        }
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        boolean toReturn = this.iter.hasNext();
        if (!toReturn) {
            this.close();
        }
        return toReturn;
    }

    @Override
    public T next() {
        this.checkFinished();
        return this.iter.next();
    }

    @Override
    public void remove() {
        this.checkFinished();
        this.iter.remove();
    }

    @Override
    public void close() {
        if (!this.finished) {
            Iter.close(this.iter);
            if (null != this.resource) {
                if (this.resource instanceof org.openjena.atlas.lib.Closeable) {
                    ((org.openjena.atlas.lib.Closeable)this.resource).close();
                } else {
                    IO.close((Closeable)this.resource);
                }
            }
            this.finished = true;
        }
    }
}

