/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarUtils {
    public static Set<Var> getVars(Triple triple) {
        HashSet<Var> x = new HashSet<Var>();
        VarUtils.addVarsFromTriple(x, triple);
        return x;
    }

    public static void addVarsFromTriple(Collection<Var> acc, Triple t) {
        VarUtils.addVar(acc, t.getSubject());
        VarUtils.addVar(acc, t.getPredicate());
        VarUtils.addVar(acc, t.getObject());
    }

    public static void addVarsFromTriplePath(Collection<Var> acc, TriplePath tpath) {
        VarUtils.addVar(acc, tpath.getSubject());
        VarUtils.addVar(acc, tpath.getObject());
    }

    public static void addVar(Collection<Var> acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(Var.alloc(n));
        }
    }

    public static void addVars(Collection<Var> acc, BasicPattern pattern) {
        VarUtils.addVars(acc, pattern.getList());
    }

    public static void addVars(Collection<Var> acc, Collection<Triple> triples) {
        for (Triple triple : triples) {
            VarUtils.addVarsFromTriple(acc, triple);
        }
    }
}

