/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetUtils {
    public static List<RDFNode> resultSetToList(ResultSet rs, String selectElement) {
        ArrayList<RDFNode> items = new ArrayList<RDFNode>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            RDFNode n = qs.get(selectElement);
            items.add(n);
        }
        return items;
    }

    public static List<String> resultSetToStringList(ResultSet rs, String selectElement, String literalOrResource) {
        ArrayList<String> items = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            RDFNode rn = qs.get(selectElement);
            if (rn.isLiteral()) {
                items.add(((Literal)rn).getLexicalForm());
                continue;
            }
            if (rn.isURIResource()) {
                items.add(((Resource)rn).getURI());
                continue;
            }
            if (rn.isAnon()) {
                items.add(((Resource)rn).getId().getLabelString());
                continue;
            }
            throw new ARQException("Unknow thing in results : " + rn);
        }
        return items;
    }

    public static ResultSet union(ResultSet ... sets) {
        return new ResultSetMem(sets);
    }
}

