/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.modify.UpdateEngine;
import com.hp.hpl.jena.sparql.modify.UpdateEngineFactory;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;

public class UpdateProcessorBase
implements UpdateProcessor {
    protected Binding initialBinding = BindingFactory.root();
    protected final UpdateRequest request;
    protected final GraphStore graphStore;
    protected final UpdateEngineFactory factory;
    protected final Context context;

    public UpdateProcessorBase(UpdateRequest request, GraphStore graphStore, Context context, UpdateEngineFactory factory) {
        this.request = request;
        this.graphStore = graphStore;
        this.context = Context.setupContext(context, graphStore);
        this.factory = factory;
    }

    public void execute() {
        UpdateEngine proc = this.factory.create(this.request, this.graphStore, this.initialBinding, this.context);
        proc.execute();
    }

    public GraphStore getGraphStore() {
        return this.graphStore;
    }

    public void setInitialBinding(QuerySolution binding) {
        this.setInitialBinding(BindingUtils.asBinding(binding));
    }

    public void setInitialBinding(Binding binding) {
        this.initialBinding = binding;
    }

    public Context getContext() {
        return this.context;
    }
}

