/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementBind;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementVisitorBase;
import com.hp.hpl.jena.sparql.syntax.ElementWalker;
import com.hp.hpl.jena.sparql.syntax.PatternVars;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxVarScope {
    public static void check(Query query2) {
        if (query2.getQueryPattern() == null) {
            return;
        }
        SyntaxVarScope.checkSubQuery(query2.getQueryPattern());
        SyntaxVarScope.checkBind(query2);
        SyntaxVarScope.checkQueryScope(query2);
        Collection<Var> vars = SyntaxVarScope.varsOfQuery(query2);
        SyntaxVarScope.check(query2, vars);
    }

    private static void checkBind(Query query2) {
        ScopeChecker v = new ScopeChecker();
        ElementWalker.walk(query2.getQueryPattern(), v);
    }

    private static void checkSubQuery(Element el) {
        SubQueryScopeChecker v = new SubQueryScopeChecker();
        ElementWalker.walk(el, v);
    }

    private static void checkQueryScope(Query query2) {
        Collection<Var> vars = SyntaxVarScope.varsOfQuery(query2);
        SyntaxVarScope.checkExprListAssignment(vars, query2.getProject());
    }

    private static Collection<Var> varsOfQuery(Query query2) {
        Collection<Var> vars = PatternVars.vars(query2.getQueryPattern());
        if (query2.hasValues()) {
            vars.addAll(query2.getValuesVariables());
        }
        return vars;
    }

    private static void check(Query query2, Collection<Var> vars) {
        SyntaxVarScope.checkExprListAssignment(vars, query2.getProject());
        if (!Syntax.syntaxARQ.equals(query2.getSyntax()) && query2.isQueryResultStar() && query2.hasGroupBy()) {
            throw new QueryParseException("SELECT * not legal with GROUP BY", -1, -1);
        }
        SyntaxVarScope.checkExprVarUse(query2);
    }

    private static void checkExprListAssignment(Collection<Var> vars, VarExprList exprList) {
        LinkedHashSet<Var> vars2 = new LinkedHashSet<Var>(vars);
        for (Var v : exprList.getVars()) {
            Expr e2 = exprList.getExpr(v);
            SyntaxVarScope.checkAssignment(vars2, e2, v);
            vars2.add(v);
        }
    }

    private static void checkExprVarUse(Query query2) {
        if (query2.hasGroupBy()) {
            VarExprList groupKey = query2.getGroupBy();
            List<Var> groupVars = groupKey.getVars();
            VarExprList exprList = query2.getProject();
            for (Var v : exprList.getVars()) {
                Expr e2 = exprList.getExpr(v);
                if (e2 == null) {
                    if (groupVars.contains((Object)v)) continue;
                    throw new QueryParseException("Non-group key variable in SELECT: " + (Object)((Object)v), -1, -1);
                }
                Set<Var> eVars = e2.getVarsMentioned();
                for (Var v2 : eVars) {
                    if (groupVars.contains((Object)v2)) continue;
                    throw new QueryParseException("Non-group key variable in SELECT: " + (Object)((Object)v2) + " in expression " + e2, -1, -1);
                }
            }
        }
    }

    private static void checkAssignment(Collection<Var> scope, Expr expr, Var var) {
        if (expr == null) {
            return;
        }
        if (scope.contains((Object)var)) {
            throw new QueryParseException("Variable used when already in-scope: " + (Object)((Object)var) + " in " + SyntaxVarScope.fmtAssignment(expr, var), -1, -1);
        }
    }

    private static String fmtExprList(VarExprList exprList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Var v : exprList.getVars()) {
            Expr e2 = exprList.getExpr(v);
            if (!first) {
                sb.append(" ");
            }
            first = false;
            sb.append("(").append(e2).append(" AS ").append((Object)v).append(")");
        }
        return sb.toString();
    }

    private static String fmtAssignment(Expr expr, Var var) {
        return "(" + expr + " AS " + (Object)((Object)var) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScopeChecker
    extends ElementVisitorBase {
        private Collection<Var> accScope = new HashSet<Var>();

        @Override
        public void visit(ElementGroup el) {
            this.accScope.clear();
            for (Element e2 : el.getElements()) {
                if (e2 instanceof ElementBind) {
                    ScopeChecker.check(this.accScope, (ElementBind)e2);
                } else if (e2 instanceof ElementService) {
                    ScopeChecker.check(this.accScope, (ElementService)e2);
                }
                if (ScopeChecker.joinedInGroup(e2)) continue;
                PatternVars.vars(this.accScope, e2);
            }
        }

        private static boolean joinedInGroup(Element e2) {
            return e2 instanceof ElementGroup || e2 instanceof ElementUnion || e2 instanceof ElementService || e2 instanceof ElementSubQuery;
        }

        private static void check(Collection<Var> scope, ElementBind el) {
            Var var = el.getVar();
            if (scope.contains((Object)var)) {
                throw new QueryParseException("BIND: Variable used when already in-scope: " + (Object)((Object)var) + " in " + el, -1, -1);
            }
            SyntaxVarScope.checkAssignment(scope, el.getExpr(), var);
        }

        private static void check(Collection<Var> scope, ElementService el) {
            Var var;
            if (ARQ.isStrictMode() && el.getServiceNode().isVariable() && !scope.contains((Object)(var = Var.alloc(el.getServiceNode())))) {
                throw new QueryParseException("SERVICE: Variable not already in-scope: " + (Object)((Object)var) + " in " + el, -1, -1);
            }
        }
    }

    private static class SubQueryScopeChecker
    extends ElementVisitorBase {
        private SubQueryScopeChecker() {
        }

        public void visit(ElementSubQuery el) {
            Query query2 = el.getQuery();
            SyntaxVarScope.checkQueryScope(query2);
            SyntaxVarScope.check(el.getQuery());
        }
    }
}

