/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import org.openjena.atlas.lib.Lib;
import org.openjena.atlas.lib.StrUtils;

public class AggGroupConcatDistinct
extends AggregatorBase {
    private final Expr expr;
    private final String separatorSeen;
    private final String separator;

    public AggGroupConcatDistinct(Expr expr, String separator) {
        this(expr, separator != null ? separator : " ", separator);
    }

    private AggGroupConcatDistinct(Expr expr, String separator, String separatorSeen) {
        this.expr = expr;
        this.separatorSeen = separatorSeen;
        this.separator = separator;
    }

    public Aggregator copy(Expr expr) {
        return new AggGroupConcatDistinct(expr, this.separator, this.separatorSeen);
    }

    public String toString() {
        String x = "GROUP_CONCAT(DISTINCT " + ExprUtils.fmtSPARQL(this.expr);
        if (this.separatorSeen != null) {
            String y = StrUtils.escapeString(this.separatorSeen);
            x = x + "; SEPARATOR='" + y + "'";
        }
        x = x + ")";
        return x;
    }

    public String toPrefixString() {
        String x = "(group_concat distinct ";
        if (this.separatorSeen != null) {
            String y = StrUtils.escapeString(this.separatorSeen);
            x = x + "(separator '" + y + "') ";
        }
        x = x + WriterExpr.asString(this.expr) + ")";
        return x;
    }

    public Accumulator createAccumulator() {
        return new AccGroupConcatDistinct(this.expr, this.separator);
    }

    public Expr getExpr() {
        return this.expr;
    }

    protected final String getSeparator() {
        return this.separator;
    }

    public Node getValueEmpty() {
        return null;
    }

    public int hashCode() {
        return 0x174 ^ this.expr.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AggGroupConcatDistinct)) {
            return false;
        }
        AggGroupConcatDistinct agg = (AggGroupConcatDistinct)other;
        return Lib.equal(agg.getSeparator(), this.getSeparator()) && agg.getExpr().equals(this.getExpr());
    }

    static class AccGroupConcatDistinct
    extends AccumulatorDistinctExpr {
        private StringBuilder stringSoFar = new StringBuilder();
        private boolean first = true;
        private final String separator;

        public AccGroupConcatDistinct(Expr expr, String sep) {
            super(expr);
            this.separator = sep;
        }

        public void accumulateDistinct(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            String str2 = nv.asString();
            if (!this.first) {
                this.stringSoFar.append(this.separator);
            }
            this.stringSoFar.append(str2);
            this.first = false;
        }

        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        public NodeValue getAccValue() {
            return NodeValue.makeString(this.stringSoFar.toString());
        }
    }
}

