/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import org.openjena.atlas.logging.Log;

public class AggCount
extends AggregatorBase {
    public Aggregator copy(Expr expr) {
        if (expr != null) {
            Log.warn(this, "Copying non-null expression for COUNT(*)");
        }
        return new AggCount();
    }

    public Expr getExpr() {
        return null;
    }

    public Accumulator createAccumulator() {
        return new AccCount();
    }

    public String toString() {
        return "count(*)";
    }

    public String toPrefixString() {
        return "(count)";
    }

    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    public int hashCode() {
        return 370;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AggCount;
    }

    static class AccCount
    implements Accumulator {
        private long count = 0L;

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

