/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.expr.RegexEngine;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexJava
implements RegexEngine {
    Pattern regexPattern;

    public RegexJava(String pattern, String flags) {
        this.regexPattern = this.makePattern(pattern, flags);
    }

    public boolean match(String s) {
        Matcher m = this.regexPattern.matcher(s);
        return m.find();
    }

    private Pattern makePattern(String patternStr, String flags) {
        try {
            int mask = 0;
            if (flags != null) {
                mask = RegexJava.makeMask(flags);
            }
            return Pattern.compile(patternStr, mask);
        }
        catch (PatternSyntaxException pEx) {
            throw new ExprException("Regex: Pattern exception: " + pEx);
        }
    }

    public static int makeMask(String modifiers) {
        if (modifiers == null) {
            return 0;
        }
        int newMask = 0;
        block5: for (int i = 0; i < modifiers.length(); ++i) {
            switch (modifiers.charAt(i)) {
                case 'i': {
                    newMask |= 0x40;
                    newMask |= 2;
                    continue block5;
                }
                case 'm': {
                    newMask |= 8;
                    continue block5;
                }
                case 's': {
                    newMask |= 0x20;
                    continue block5;
                }
                default: {
                    throw new QueryParseException("Illegal flag in regex modifiers: " + modifiers.charAt(i), -1, -1);
                }
            }
        }
        return newMask;
    }
}

