/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformScopeRename;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineBase;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorCheck;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorTiming;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.util.Context;

public class QueryEngineMain
extends QueryEngineBase {
    public static boolean SUBSTITUE = true;
    private static QueryEngineFactory factory = new QueryEngineFactory(){

        public boolean accept(Query query2, DatasetGraph dataset, Context context) {
            return true;
        }

        public Plan create(Query query2, DatasetGraph dataset, Binding input, Context context) {
            QueryEngineMain engine = new QueryEngineMain(query2, dataset, input, context);
            return engine.getPlan();
        }

        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return true;
        }

        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineMain engine = new QueryEngineMain(op, dataset, binding, context);
            return engine.getPlan();
        }
    };

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory(factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory(factory);
    }

    public QueryEngineMain(Op op, DatasetGraph dataset, Binding input, Context context) {
        super(op, dataset, input, context);
    }

    public QueryEngineMain(Query query2, DatasetGraph dataset, Binding input, Context context) {
        super(query2, dataset, input, context);
    }

    public QueryIterator eval(Op op, DatasetGraph dsg, Binding input, Context context) {
        if (SUBSTITUE && !input.isEmpty()) {
            op = Substitute.substitute(op, input);
        }
        ExecutionContext execCxt = new ExecutionContext(context, dsg.getDefaultGraph(), dsg, QC.getFactory(context));
        QueryIterRoot qIter1 = QueryIterRoot.create(input, execCxt);
        QueryIterator qIter = QC.execute(op, qIter1, execCxt);
        qIter = QueryIteratorCheck.check(qIter, execCxt);
        if (context.isTrue(ARQ.enableExecutionTimeLogging)) {
            qIter = QueryIteratorTiming.time(qIter);
        }
        return qIter;
    }

    protected Op modifyOp(Op op) {
        if (this.context.isFalse(ARQ.optimization)) {
            return this.minimalModifyOp(op);
        }
        return Algebra.optimize(op, this.context);
    }

    protected Op minimalModifyOp(Op op) {
        return TransformScopeRename.transform(op);
    }
}

