/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLabel;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpMinus;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpPropFunc;
import com.hp.hpl.jena.sparql.algebra.op.OpQuad;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpTopN;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterAssign;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterDiff;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterDistinct;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterFilterExpr;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterGroup;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterMinus;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPath;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProcedure;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProject;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProject2;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterReduced;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSlice;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSort;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterTopN;
import com.hp.hpl.jena.sparql.engine.main.ExecutionDispatch;
import com.hp.hpl.jena.sparql.engine.main.OpExecutorFactory;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterGraph;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterJoin;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterLeftJoin;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterOptionalIndex;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterService;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterUnion;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.procedure.ProcEval;
import com.hp.hpl.jena.sparql.procedure.Procedure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpExecutor {
    protected static final OpExecutorFactory stdFactory = new OpExecutorFactory(){

        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutor(execCxt);
        }
    };
    protected ExecutionContext execCxt;
    protected ExecutionDispatch dispatcher = null;
    protected static final int TOP_LEVEL = 0;
    protected int level = -1;

    private static OpExecutor createOpExecutor(ExecutionContext execCxt) {
        OpExecutorFactory factory = execCxt.getExecutor();
        if (factory == null) {
            factory = stdFactory;
        }
        if (factory == null) {
            return new OpExecutor(execCxt);
        }
        return factory.create(execCxt);
    }

    static QueryIterator execute(Op op, ExecutionContext execCxt) {
        return OpExecutor.execute(op, OpExecutor.createRootQueryIterator(execCxt), execCxt);
    }

    static QueryIterator execute(Op op, QueryIterator qIter, ExecutionContext execCxt) {
        OpExecutor exec = OpExecutor.createOpExecutor(execCxt);
        QueryIterator q = exec.executeOp(op, qIter);
        return q;
    }

    protected OpExecutor(ExecutionContext execCxt) {
        this.execCxt = execCxt;
        this.dispatcher = new ExecutionDispatch(this);
    }

    public QueryIterator executeOp(Op op, QueryIterator input) {
        ++this.level;
        QueryIterator qIter = this.dispatcher.exec(op, input);
        --this.level;
        return qIter;
    }

    protected QueryIterator execute(OpBGP opBGP, QueryIterator input) {
        BasicPattern pattern = opBGP.getPattern();
        return StageBuilder.execute(pattern, input, this.execCxt);
    }

    protected QueryIterator execute(OpTriple opTriple, QueryIterator input) {
        return this.execute(opTriple.asBGP(), input);
    }

    protected QueryIterator execute(OpQuad opQuad, QueryIterator input) {
        return this.execute(opQuad.asQuadPattern(), input);
    }

    protected QueryIterator execute(OpQuadPattern quadPattern, QueryIterator input) {
        if (quadPattern.isDefaultGraph() && this.execCxt.getActiveGraph() == this.execCxt.getDataset().getDefaultGraph()) {
            OpBGP opBGP = new OpBGP(quadPattern.getBasicPattern());
            return this.execute(opBGP, input);
        }
        if (Quad.isUnionGraph(quadPattern.getGraphNode())) {
            Log.warn(this, "Not implemented yet: quad/union default graph in general OpExecutor");
        }
        OpBGP opBGP = new OpBGP(quadPattern.getBasicPattern());
        OpGraph op = new OpGraph(quadPattern.getGraphNode(), opBGP);
        return this.execute(op, input);
    }

    protected QueryIterator execute(OpPath opPath, QueryIterator input) {
        return new QueryIterPath(opPath.getTriplePath(), input, this.execCxt);
    }

    protected QueryIterator execute(OpProcedure opProc, QueryIterator input) {
        Procedure procedure = ProcEval.build(opProc, this.execCxt);
        QueryIterator qIter = this.executeOp(opProc.getSubOp(), input);
        return new QueryIterProcedure(qIter, procedure, this.execCxt);
    }

    protected QueryIterator execute(OpPropFunc opPropFunc, QueryIterator input) {
        Procedure procedure = ProcEval.build(opPropFunc.getProperty(), opPropFunc.getSubjectArgs(), opPropFunc.getObjectArgs(), this.execCxt);
        QueryIterator qIter = this.executeOp(opPropFunc.getSubOp(), input);
        return new QueryIterProcedure(qIter, procedure, this.execCxt);
    }

    protected QueryIterator execute(OpJoin opJoin, QueryIterator input) {
        QueryIterator left = this.executeOp(opJoin.getLeft(), input);
        QueryIterator right = this.executeOp(opJoin.getRight(), this.root());
        QueryIterJoin qIter = new QueryIterJoin(left, right, this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpSequence opSequence, QueryIterator input) {
        QueryIterator qIter = input;
        Iterator<Op> iter = opSequence.iterator();
        while (iter.hasNext()) {
            Op sub = iter.next();
            qIter = this.executeOp(sub, qIter);
        }
        return qIter;
    }

    protected QueryIterator execute(OpDisjunction opDisjunction, QueryIterator input) {
        QueryIterUnion cIter = new QueryIterUnion(input, opDisjunction.getElements(), this.execCxt);
        return cIter;
    }

    protected QueryIterator execute(OpLeftJoin opLeftJoin, QueryIterator input) {
        QueryIterator left = this.executeOp(opLeftJoin.getLeft(), input);
        QueryIterator right = this.executeOp(opLeftJoin.getRight(), this.root());
        QueryIterLeftJoin qIter = new QueryIterLeftJoin(left, right, opLeftJoin.getExprs(), this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpConditional opCondition, QueryIterator input) {
        QueryIterator left = this.executeOp(opCondition.getLeft(), input);
        QueryIterOptionalIndex qIter = new QueryIterOptionalIndex(left, opCondition.getRight(), this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpDiff opDiff, QueryIterator input) {
        QueryIterator left = this.executeOp(opDiff.getLeft(), input);
        QueryIterator right = this.executeOp(opDiff.getRight(), this.root());
        return new QueryIterDiff(left, right, this.execCxt);
    }

    protected QueryIterator execute(OpMinus opMinus, QueryIterator input) {
        QueryIterator left = this.executeOp(opMinus.getLeft(), input);
        QueryIterator right = this.executeOp(opMinus.getRight(), this.root());
        return new QueryIterMinus(left, right, this.execCxt);
    }

    protected QueryIterator execute(OpUnion opUnion, QueryIterator input) {
        List<Op> x = this.flattenUnion(opUnion);
        QueryIterUnion cIter = new QueryIterUnion(input, x, this.execCxt);
        return cIter;
    }

    protected List<Op> flattenUnion(OpUnion opUnion) {
        ArrayList<Op> x = new ArrayList<Op>();
        this.flattenUnion(x, opUnion);
        return x;
    }

    protected void flattenUnion(List<Op> acc, OpUnion opUnion) {
        if (opUnion.getLeft() instanceof OpUnion) {
            this.flattenUnion(acc, (OpUnion)opUnion.getLeft());
        } else {
            acc.add(opUnion.getLeft());
        }
        if (opUnion.getRight() instanceof OpUnion) {
            this.flattenUnion(acc, (OpUnion)opUnion.getRight());
        } else {
            acc.add(opUnion.getRight());
        }
    }

    protected QueryIterator execute(OpFilter opFilter, QueryIterator input) {
        ExprList exprs = opFilter.getExprs();
        Op base = opFilter.getSubOp();
        QueryIterator qIter = this.executeOp(base, input);
        for (Expr expr : exprs) {
            qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
        }
        return qIter;
    }

    protected QueryIterator execute(OpGraph opGraph, QueryIterator input) {
        QueryIterator qIter = this.specialcase(opGraph.getNode(), opGraph.getSubOp(), input);
        if (qIter != null) {
            return qIter;
        }
        return new QueryIterGraph(input, opGraph, this.execCxt);
    }

    private QueryIterator specialcase(Node gn, Op subOp, QueryIterator input) {
        if (Quad.isDefaultGraph(gn)) {
            ExecutionContext cxt2 = new ExecutionContext(this.execCxt, this.execCxt.getDataset().getDefaultGraph());
            return OpExecutor.execute(subOp, input, cxt2);
        }
        return null;
    }

    protected QueryIterator execute(OpService opService, QueryIterator input) {
        return new QueryIterService(input, opService, this.execCxt);
    }

    protected QueryIterator execute(OpDatasetNames dsNames, QueryIterator input) {
        throw new ARQNotImplemented("execute/OpDatasetNames");
    }

    protected QueryIterator execute(OpTable opTable, QueryIterator input) {
        if (opTable.isJoinIdentity()) {
            return input;
        }
        if (input instanceof QueryIterRoot) {
            input.close();
            return opTable.getTable().iterator(this.execCxt);
        }
        QueryIterator qIterT = opTable.getTable().iterator(this.execCxt);
        QueryIterJoin qIter = new QueryIterJoin(input, qIterT, this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpExt opExt, QueryIterator input) {
        try {
            QueryIterator qIter = opExt.eval(input, this.execCxt);
            if (qIter != null) {
                return qIter;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        throw new QueryExecException("Encountered unsupported OpExt: " + opExt.getName());
    }

    protected QueryIterator execute(OpLabel opLabel, QueryIterator input) {
        if (!opLabel.hasSubOp()) {
            return input;
        }
        return this.executeOp(opLabel.getSubOp(), input);
    }

    protected QueryIterator execute(OpNull opNull, QueryIterator input) {
        input.close();
        return new QueryIterNullIterator(this.execCxt);
    }

    protected QueryIterator execute(OpList opList, QueryIterator input) {
        return this.executeOp(opList.getSubOp(), input);
    }

    protected QueryIterator execute(OpOrder opOrder, QueryIterator input) {
        QueryIterator qIter = this.executeOp(opOrder.getSubOp(), input);
        qIter = new QueryIterSort(qIter, opOrder.getConditions(), this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpTopN opTop, QueryIterator input) {
        QueryIterator qIter = null;
        if (opTop.getSubOp() instanceof OpDistinct) {
            OpDistinct opDistinct = (OpDistinct)opTop.getSubOp();
            qIter = this.executeOp(opDistinct.getSubOp(), input);
            qIter = new QueryIterTopN(qIter, opTop.getConditions(), (long)opTop.getLimit(), true, this.execCxt);
        } else {
            qIter = this.executeOp(opTop.getSubOp(), input);
            qIter = new QueryIterTopN(qIter, opTop.getConditions(), (long)opTop.getLimit(), false, this.execCxt);
        }
        return qIter;
    }

    protected QueryIterator execute(OpProject opProject, QueryIterator input) {
        if (input instanceof QueryIterRoot) {
            QueryIterator qIter = this.executeOp(opProject.getSubOp(), input);
            qIter = new QueryIterProject(qIter, opProject.getVars(), this.execCxt);
            return qIter;
        }
        QueryIterProject2 qIter = new QueryIterProject2(opProject, input, this, this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpSlice opSlice, QueryIterator input) {
        QueryIterator qIter = this.executeOp(opSlice.getSubOp(), input);
        qIter = new QueryIterSlice(qIter, opSlice.getStart(), opSlice.getLength(), this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpGroup opGroup, QueryIterator input) {
        QueryIterator qIter = this.executeOp(opGroup.getSubOp(), input);
        qIter = new QueryIterGroup(qIter, opGroup.getGroupVars(), opGroup.getAggregators(), this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpDistinct opDistinct, QueryIterator input) {
        QueryIterator qIter = this.executeOp(opDistinct.getSubOp(), input);
        qIter = new QueryIterDistinct(qIter, this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpReduced opReduced, QueryIterator input) {
        QueryIterator qIter = this.executeOp(opReduced.getSubOp(), input);
        qIter = new QueryIterReduced(qIter, this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpAssign opAssign, QueryIterator input) {
        QueryIterator qIter = this.executeOp(opAssign.getSubOp(), input);
        qIter = new QueryIterAssign(qIter, opAssign.getVarExprList(), this.execCxt, false);
        return qIter;
    }

    protected QueryIterator execute(OpExtend opExtend, QueryIterator input) {
        QueryIterator qIter = this.executeOp(opExtend.getSubOp(), input);
        qIter = new QueryIterAssign(qIter, opExtend.getVarExprList(), this.execCxt, true);
        return qIter;
    }

    public static QueryIterator createRootQueryIterator(ExecutionContext execCxt) {
        return QueryIterRoot.create(execCxt);
    }

    protected QueryIterator root() {
        return OpExecutor.createRootQueryIterator(this.execCxt);
    }

    private QueryIterator debug(String marker, QueryIterator input) {
        List<Binding> x = OpExecutor.all(input);
        for (Binding b : x) {
            System.out.print(marker);
            System.out.print(": ");
            System.out.println(b);
        }
        return new QueryIterPlainWrapper(x.iterator(), this.execCxt);
    }

    private static List<Binding> all(QueryIterator input) {
        return Iter.toList(input);
    }
}

