/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.binding;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.jena.iri.IRI;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.RiotException;
import org.openjena.riot.out.NodeFormatter;
import org.openjena.riot.out.NodeFormatterTTL;
import org.openjena.riot.system.PrefixMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingOutputStream
implements Sink<Binding> {
    private final Writer bw;
    private Binding lastBinding = null;
    private List<Var> vars = null;
    private PrefixMap pmap;
    private NodeFormatter nodeFormatter;
    private boolean needOutputPMap = true;
    private boolean needOutputVars = true;

    public BindingOutputStream(OutputStream out) {
        this(out, null, null);
    }

    public BindingOutputStream(OutputStream out, PrefixMap prefixMapping) {
        this(out, null, prefixMapping);
    }

    public BindingOutputStream(OutputStream out, List<Var> vars) {
        this(out, vars, null);
    }

    public BindingOutputStream(OutputStream out, List<Var> vars, PrefixMap prefixMapping) {
        this(IO.asBufferedUTF8(out), vars, prefixMapping);
    }

    private BindingOutputStream(Writer out, List<Var> variables, PrefixMap prefixMapping) {
        this.bw = out;
        this.vars = variables;
        this.pmap = prefixMapping;
        this.nodeFormatter = new NodeFormatterTTL(null, this.pmap);
        this.needOutputVars = this.vars != null && this.vars.size() > 0;
    }

    public final void write(Binding binding) {
        this.send(binding);
    }

    @Override
    public void send(Binding binding) {
        try {
            if (this.needOutputPMap) {
                if (this.pmap != null) {
                    for (Map.Entry entry : this.pmap.getMapping().entrySet()) {
                        this.bw.write("PREFIX ");
                        this.bw.write((String)entry.getKey());
                        this.bw.write(": <");
                        this.bw.write(((IRI)entry.getValue()).toASCIIString());
                        this.bw.write("> .\n");
                    }
                }
                this.needOutputPMap = false;
            }
            if (BindingOutputStream.needVars(this.vars, binding)) {
                this.vars = Iter.toList(binding.vars());
                this.needOutputVars = true;
            }
            if (this.needOutputVars) {
                if (binding.size() == 0 && this.vars.size() == 0) {
                    this.bw.write(".\n");
                    this.needOutputVars = false;
                    return;
                }
                this.bw.write("VARS");
                for (Var var : this.vars) {
                    this.bw.write(" ?");
                    this.bw.write(var.getVarName());
                }
                this.bw.write(" .\n");
                this.needOutputVars = false;
            }
            for (Var var : this.vars) {
                Node n = binding.get(var);
                if (n == null) {
                    this.bw.write("- ");
                    continue;
                }
                this.nodeFormatter.format(this.bw, n);
                this.bw.write(" ");
            }
            this.bw.write(".\n");
        }
        catch (IOException ex) {
            throw new RiotException(ex);
        }
    }

    private static boolean needVars(List<Var> vars, Binding binding) {
        if (vars == null) {
            return true;
        }
        for (Var v : vars) {
            if (binding.contains(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        IO.flush(this.bw);
    }

    @Override
    public void close() {
        IO.close(this.bw);
    }

    public List<Var> getVars() {
        return this.vars;
    }

    public void setVars(List<Var> vars) {
        this.vars = vars;
    }

    public PrefixMap getPrefixMap() {
        return this.pmap;
    }

    public void setPrefixMap(PrefixMap pmap) {
        this.pmap = pmap;
        this.needOutputPMap = true;
    }
}

