/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.binding;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.iri.IRI;
import org.openjena.atlas.iterator.IteratorSlotted;
import org.openjena.atlas.lib.Closeable;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerFactory;
import org.openjena.riot.lang.LabelToNode;
import org.openjena.riot.lang.LangEngine;
import org.openjena.riot.out.NodeFmtLib;
import org.openjena.riot.system.IRIResolver;
import org.openjena.riot.system.ParserProfile;
import org.openjena.riot.system.ParserProfileBase;
import org.openjena.riot.system.PrefixMap;
import org.openjena.riot.system.Prologue;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingInputStream
extends LangEngine
implements Iterator<Binding>,
Closeable {
    private final IteratorTuples iter = new IteratorTuples();

    public BindingInputStream(InputStream in) {
        this(TokenizerFactory.makeTokenizerUTF8(in));
    }

    public BindingInputStream(Tokenizer tokenizer) {
        this(tokenizer, BindingInputStream.profile());
    }

    static ParserProfile profile() {
        Prologue prologue = new Prologue(new PrefixMap(), IRIResolver.createNoResolve());
        ErrorHandler handler = ErrorHandlerFactory.errorHandlerStd;
        ParserProfileBase profile = new ParserProfileBase(prologue, handler);
        profile.setLabelToNode(LabelToNode.createUseLabelAsGiven());
        return profile;
    }

    private BindingInputStream(Tokenizer tokenizer, ParserProfile profile) {
        super(tokenizer, profile);
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public Binding next() {
        return (Binding)this.iter.next();
    }

    @Override
    public void remove() {
        this.iter.remove();
    }

    public List<Var> vars() {
        return Collections.unmodifiableList(this.iter.vars);
    }

    @Override
    public void close() {
        this.tokens.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IteratorTuples
    extends IteratorSlotted<Binding> {
        private Binding lastLine;
        List<Var> vars = new ArrayList<Var>();

        public IteratorTuples() {
            this.directives();
        }

        private void directives() {
            while (BindingInputStream.this.lookingAt(TokenType.KEYWORD)) {
                Token t = BindingInputStream.this.nextToken();
                if (t.getImage().equalsIgnoreCase("VARS")) {
                    this.directiveVars();
                    continue;
                }
                if (!t.getImage().equalsIgnoreCase("PREFIX")) continue;
                this.directivePrefix();
            }
        }

        @Override
        protected Binding moveToNext() {
            this.directives();
            BindingMap binding = BindingFactory.create();
            int i = 0;
            while (!BindingInputStream.this.lookingAt(TokenType.DOT)) {
                if (i >= this.vars.size()) {
                    BindingInputStream.this.exception(BindingInputStream.this.peekToken(), "Too many items in a line.  Expected " + this.vars.size(), new Object[0]);
                }
                Var v = this.vars.get(i);
                Token token = BindingInputStream.this.nextToken();
                if (!token.hasType(TokenType.MINUS)) {
                    Node n = token.hasType(TokenType.STAR) || token.isCtlCode() && token.getCntrlCode() == -1 ? this.lastLine.get(v) : (token.hasType(TokenType.BNODE) ? Node.createAnon((AnonId)new AnonId(NodeFmtLib.decodeBNodeLabel(token.getImage()))) : BindingInputStream.this.profile.create(null, token));
                    binding.add(v, n);
                }
                ++i;
            }
            if (BindingInputStream.this.eof()) {
                BindingInputStream.this.exception(BindingInputStream.this.peekToken(), "Line does not end with a DOT", new Object[0]);
            }
            Token dot = BindingInputStream.this.nextToken();
            if (i != this.vars.size()) {
                Var v = this.vars.get(this.vars.size() - 1);
                BindingInputStream.this.exception(dot, "Too many items in a line.  Expected " + this.vars.size(), new Object[0]);
            }
            this.lastLine = binding;
            return binding;
        }

        @Override
        protected boolean hasMore() {
            return BindingInputStream.this.moreTokens();
        }

        private void directiveVars() {
            this.vars.clear();
            while (!BindingInputStream.this.eof() && !BindingInputStream.this.lookingAt(TokenType.DOT)) {
                Token t = BindingInputStream.this.nextToken();
                if (!t.hasType(TokenType.VAR)) {
                    BindingInputStream.this.exception(t, "VARS requires a list of variables (found '" + t + "')", new Object[0]);
                }
                Var v = Var.alloc(t.getImage());
                this.vars.add(v);
            }
            BindingInputStream.this.nextToken();
        }

        private void directivePrefix() {
            if (!BindingInputStream.this.lookingAt(TokenType.PREFIXED_NAME)) {
                BindingInputStream.this.exception(BindingInputStream.this.peekToken(), "PREFIX requires a prefix (found '" + BindingInputStream.this.peekToken() + "')", new Object[0]);
            }
            if (BindingInputStream.this.peekToken().getImage2().length() != 0) {
                BindingInputStream.this.exception(BindingInputStream.this.peekToken(), "PREFIX requires a prefix and no suffix (found '" + BindingInputStream.this.peekToken() + "')", new Object[0]);
            }
            String prefix = BindingInputStream.this.peekToken().getImage();
            BindingInputStream.this.nextToken();
            if (!BindingInputStream.this.lookingAt(TokenType.IRI)) {
                BindingInputStream.this.exception(BindingInputStream.this.peekToken(), "@prefix requires an IRI (found '" + BindingInputStream.this.peekToken() + "')", new Object[0]);
            }
            String iriStr = BindingInputStream.this.peekToken().getImage();
            IRI iri2 = BindingInputStream.this.profile.makeIRI(iriStr, BindingInputStream.this.currLine, BindingInputStream.this.currCol);
            BindingInputStream.this.profile.getPrologue().getPrefixMap().add(prefix, iri2);
            BindingInputStream.this.nextToken();
            BindingInputStream.this.expect("PREFIX directive not terminated by a dot", TokenType.DOT);
        }
    }
}

