/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpTopN
extends OpModifier {
    private final List<SortCondition> conditions;
    private final int limit;

    public OpTopN(Op subOp, int N, List<SortCondition> conditions) {
        super(subOp);
        this.conditions = conditions;
        this.limit = N;
    }

    public List<SortCondition> getConditions() {
        return this.conditions;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public String getName() {
        return "top";
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op copy(Op subOp) {
        return new OpTopN(subOp, this.limit, this.conditions);
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public int hashCode() {
        return ((Object)this.conditions).hashCode() ^ this.getSubOp().hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpTopN)) {
            return false;
        }
        OpTopN opTopN = (OpTopN)other;
        return this.getSubOp().equalTo(opTopN.getSubOp(), labelMap);
    }
}

