/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import org.apache.jena.iri.IRI;
import org.openjena.riot.system.IRIResolver;

public class ModLangParse
implements ArgModuleGeneral {
    private ArgDecl argCheck = new ArgDecl(false, "check");
    private ArgDecl argNoCheck = new ArgDecl(false, "nocheck", "noCheck");
    private ArgDecl argSink = new ArgDecl(false, "sink", "null");
    private ArgDecl argStrict = new ArgDecl(false, "strict");
    private ArgDecl argValidate = new ArgDecl(false, "validate");
    private ArgDecl argSkip = new ArgDecl(false, "skip");
    private ArgDecl argNoSkip = new ArgDecl(false, "noSkip");
    private ArgDecl argStop = new ArgDecl(false, "stopOnError", "stoponerror", "stop");
    private ArgDecl argBase = new ArgDecl(true, "base");
    private ArgDecl argRDFS = new ArgDecl(true, "rdfs");
    private String rdfsVocabFilename = null;
    private Model rdfsVocab = null;
    private String baseIRI = null;
    private boolean explicitCheck = false;
    private boolean explicitNoCheck = false;
    private boolean skipOnBadTerm = false;
    private boolean stopOnBadTerm = false;
    private boolean bitbucket = false;
    private boolean strict = false;
    private boolean validate = false;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Parser control");
        cmdLine.add(this.argSink, "--sink", "Parse but throw away output");
        cmdLine.add(this.argBase, "--base=URI", "Set the base URI (does not apply to N-triples and N-Quads)");
        cmdLine.add(this.argCheck, "--check", "Addition checking of RDF terms");
        cmdLine.add(this.argStrict, "--strict", "Run with in strict mode");
        cmdLine.add(this.argValidate, "--validate", "Same as --sink --check=true --strict");
        cmdLine.add(this.argNoCheck, "--nocheck", "Turn off checking of RDF terms");
        cmdLine.add(this.argStop, "--stop", "Stop parsing on encountering a bad RDF term");
    }

    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(this.argValidate)) {
            this.validate = true;
            this.strict = true;
            this.explicitCheck = true;
            this.bitbucket = true;
        }
        if (cmdLine.contains(this.argCheck)) {
            this.explicitCheck = true;
        }
        if (cmdLine.contains(this.argNoCheck)) {
            this.explicitNoCheck = true;
        }
        if (cmdLine.contains(this.argStrict)) {
            this.strict = true;
        }
        if (cmdLine.contains(this.argSkip)) {
            this.skipOnBadTerm = true;
        }
        if (cmdLine.contains(this.argNoSkip)) {
            this.skipOnBadTerm = false;
        }
        if (cmdLine.contains(this.argBase)) {
            this.baseIRI = cmdLine.getValue(this.argBase);
            IRI iri2 = IRIResolver.resolveIRI(this.baseIRI);
            if (iri2.hasViolation(false)) {
                throw new CmdException("Bad base IRI: " + this.baseIRI);
            }
            if (!iri2.isAbsolute()) {
                throw new CmdException("Base IRI must be an absolute IRI: " + this.baseIRI);
            }
        }
        if (cmdLine.contains(this.argStop)) {
            this.stopOnBadTerm = true;
        }
        if (cmdLine.contains(this.argSink)) {
            this.bitbucket = true;
        }
        if (cmdLine.contains(this.argRDFS)) {
            this.rdfsVocabFilename = cmdLine.getArg(this.argRDFS).getValue();
            this.rdfsVocab = FileManager.get().loadModel(this.rdfsVocabFilename);
        }
    }

    public boolean explicitChecking() {
        return this.explicitCheck;
    }

    public boolean explicitNoChecking() {
        return this.explicitNoCheck;
    }

    public boolean strictMode() {
        return this.strict;
    }

    public boolean validate() {
        return this.validate;
    }

    public boolean skipOnBadTerm() {
        return this.skipOnBadTerm;
    }

    public boolean stopOnBadTerm() {
        return this.stopOnBadTerm;
    }

    public boolean toBitBucket() {
        return this.bitbucket;
    }

    public String getBaseIRI() {
        return this.baseIRI;
    }

    public Model getRDFSVocab() {
        return this.rdfsVocab;
    }
}

