/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModDataset;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.core.DataFormat;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.util.DatasetUtils;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import java.util.ArrayList;
import java.util.List;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModDatasetGeneral
extends ModDataset {
    protected final ArgDecl graphDecl = new ArgDecl(true, "graph", "data");
    protected final ArgDecl namedGraphDecl = new ArgDecl(true, "named", "namedgraph", "namedGraph", "namedData", "nameddata");
    protected final ArgDecl lmapDecl = new ArgDecl(true, "lmap");
    private List<String> graphURLs = null;
    private List<String> namedGraphURLs = null;
    private DataFormat dataSyntax = null;
    private FileManager fileManager = FileManager.get();

    @Override
    public void registerWith(CmdGeneral cl) {
        cl.getUsage().startCategory("Dataset");
        cl.add(this.graphDecl, "--graph", "Graph for default graph of the datset");
        cl.add(this.namedGraphDecl, "--namedGraph", "Add a graph into the dataset as a named graph");
        cl.add(this.lmapDecl, "--lmap", "Specify a location mapping file");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        this.graphURLs = cmdLine.getValues(this.graphDecl);
        this.namedGraphURLs = cmdLine.getValues(this.namedGraphDecl);
        if (cmdLine.contains(this.lmapDecl)) {
            String lmapFile = cmdLine.getValue(this.lmapDecl);
            LocationMapper locMap = new LocationMapper(lmapFile);
            this.fileManager = new FileManager(locMap);
        }
    }

    @Override
    public Dataset createDataset() {
        if (!(this.graphURLs != null && this.graphURLs.size() != 0 || this.namedGraphURLs != null && this.namedGraphURLs.size() != 0)) {
            return null;
        }
        DatasetGraph dsg = DatasetGraphFactory.createMem();
        DataSource ds = DatasetFactory.create(dsg);
        this.addGraphs(ds);
        this.dataset = ds;
        return this.dataset;
    }

    protected void addGraphs(Dataset ds) {
        try {
            if (this.graphURLs != null || this.namedGraphURLs != null) {
                ArrayList<String> triples = new ArrayList<String>();
                ArrayList<String> quads = new ArrayList<String>();
                for (String fn : this.graphURLs) {
                    if (Lang.guess(fn).isQuads()) {
                        quads.add(fn);
                        continue;
                    }
                    triples.add(fn);
                }
                for (String fn : quads) {
                    RiotLoader.read(fn, ds.asDatasetGraph());
                }
                this.dataset = DatasetUtils.addInGraphs(ds, triples, this.namedGraphURLs, this.fileManager, null);
            }
        }
        catch (LabelExistsException ex) {
            throw new CmdException(ex.getMessage());
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Error creating dataset", ex);
        }
    }

    public List<String> getGraphURLs() {
        return this.graphURLs;
    }

    public List<String> getNamedGraphURLs() {
        return this.namedGraphURLs;
    }
}

