/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.utils;

import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.wink.common.internal.utils.FileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletFileLoader
extends FileLoader {
    private static final Logger logger = LoggerFactory.getLogger(ServletFileLoader.class);

    public static InputStream loadFileAsStream(ServletContext servletContext, String fileName) throws FileNotFoundException {
        if (fileName == null || fileName.trim().equals("")) {
            throw new NullPointerException("fileName");
        }
        if (servletContext != null) {
            InputStream is;
            logger.trace("Searching for {} using servlet context.", (Object)fileName);
            if (fileName.startsWith("/") && (is = servletContext.getResourceAsStream(fileName)) != null) {
                return is;
            }
        }
        return FileLoader.loadFileAsStream((String)fileName);
    }
}

