/*
 * Decompiled with CFR 0.152.
 */
package net.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.client.OAuthClient;
import net.oauth.http.HttpMessage;
import net.oauth.signature.OAuthSignatureMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthMessage {
    public String method;
    public String URL;
    private final List<Map.Entry<String, String>> parameters;
    private Map<String, String> parameterMap;
    private boolean parametersAreComplete = false;
    private final List<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
    private final InputStream bodyAsStream;
    public static final String AUTH_SCHEME = "OAuth";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    private static final Pattern AUTHORIZATION = Pattern.compile("\\s*(\\w*)\\s+(.*)");
    private static final Pattern NVP = Pattern.compile("(\\S*)\\s*\\=\\s*\"([^\"]*)\"");

    public OAuthMessage(String method, String URL, Collection<? extends Map.Entry> parameters) {
        this(method, URL, parameters, null);
    }

    public OAuthMessage(String method, String URL, Collection<? extends Map.Entry> parameters, InputStream bodyAsStream) {
        this.method = method;
        this.URL = URL;
        this.bodyAsStream = bodyAsStream;
        if (parameters == null) {
            this.parameters = new ArrayList<Map.Entry<String, String>>();
        } else {
            this.parameters = new ArrayList<Map.Entry<String, String>>(parameters.size());
            for (Map.Entry entry : parameters) {
                this.parameters.add(new OAuth.Parameter(OAuthMessage.toString(entry.getKey()), OAuthMessage.toString(entry.getValue())));
            }
        }
    }

    public String toString() {
        return "OAuthMessage(" + this.method + ", " + this.URL + ", " + this.parameters + ")";
    }

    private void beforeGetParameter() throws IOException {
        if (!this.parametersAreComplete) {
            this.completeParameters();
            this.parametersAreComplete = true;
        }
    }

    protected void completeParameters() throws IOException {
    }

    public List<Map.Entry<String, String>> getParameters() throws IOException {
        this.beforeGetParameter();
        return Collections.unmodifiableList(this.parameters);
    }

    public void addParameter(String key, String value) {
        this.addParameter(new OAuth.Parameter(key, value));
    }

    public void addParameter(Map.Entry<String, String> parameter) {
        this.parameters.add(parameter);
        this.parameterMap = null;
    }

    public void addParameters(Collection<? extends Map.Entry<String, String>> parameters) {
        this.parameters.addAll(parameters);
        this.parameterMap = null;
    }

    public String getParameter(String name) throws IOException {
        return this.getParameterMap().get(name);
    }

    public String getConsumerKey() throws IOException {
        return this.getParameter("oauth_consumer_key");
    }

    public String getToken() throws IOException {
        return this.getParameter("oauth_token");
    }

    public String getSignatureMethod() throws IOException {
        return this.getParameter("oauth_signature_method");
    }

    public String getSignature() throws IOException {
        return this.getParameter("oauth_signature");
    }

    protected Map<String, String> getParameterMap() throws IOException {
        this.beforeGetParameter();
        if (this.parameterMap == null) {
            this.parameterMap = OAuth.newMap(this.parameters);
        }
        return this.parameterMap;
    }

    public String getBodyType() {
        return this.getHeader("Content-Type");
    }

    public String getBodyEncoding() {
        return "ISO-8859-1";
    }

    public final String getHeader(String name) {
        String value = null;
        for (Map.Entry<String, String> header : this.getHeaders()) {
            if (!name.equalsIgnoreCase(header.getKey())) continue;
            value = header.getValue();
        }
        return value;
    }

    public final List<Map.Entry<String, String>> getHeaders() {
        return this.headers;
    }

    public final String readBodyAsString() throws IOException {
        InputStream body = this.getBodyAsStream();
        return OAuthMessage.readAll(body, this.getBodyEncoding());
    }

    public InputStream getBodyAsStream() throws IOException {
        return this.bodyAsStream;
    }

    public Map<String, Object> getDump() throws IOException {
        HashMap<String, Object> into = new HashMap<String, Object>();
        this.dump(into);
        return into;
    }

    protected void dump(Map<String, Object> into) throws IOException {
        into.put("URL", this.URL);
        if (this.parametersAreComplete) {
            try {
                into.putAll(this.getParameterMap());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void requireParameters(String ... names) throws OAuthProblemException, IOException {
        Set<String> present = this.getParameterMap().keySet();
        ArrayList<String> absent = new ArrayList<String>();
        for (String required : names) {
            if (present.contains(required)) continue;
            absent.add(required);
        }
        if (!absent.isEmpty()) {
            OAuthProblemException problem = new OAuthProblemException("parameter_absent");
            problem.setParameter("oauth_parameters_absent", OAuth.percentEncode(absent));
            throw problem;
        }
    }

    public void addRequiredParameters(OAuthAccessor accessor) throws OAuthException, IOException, URISyntaxException {
        String signatureMethod;
        Map<String, String> pMap = OAuth.newMap(this.parameters);
        if (pMap.get("oauth_token") == null && accessor.accessToken != null) {
            this.addParameter("oauth_token", accessor.accessToken);
        }
        OAuthConsumer consumer = accessor.consumer;
        if (pMap.get("oauth_consumer_key") == null) {
            this.addParameter("oauth_consumer_key", consumer.consumerKey);
        }
        if ((signatureMethod = pMap.get("oauth_signature_method")) == null) {
            signatureMethod = (String)consumer.getProperty("oauth_signature_method");
            if (signatureMethod == null) {
                signatureMethod = "HMAC-SHA1";
            }
            this.addParameter("oauth_signature_method", signatureMethod);
        }
        if (pMap.get("oauth_timestamp") == null) {
            this.addParameter("oauth_timestamp", System.currentTimeMillis() / 1000L + "");
        }
        if (pMap.get("oauth_nonce") == null) {
            this.addParameter("oauth_nonce", System.nanoTime() + "");
        }
        if (pMap.get("oauth_version") == null) {
            this.addParameter("oauth_version", "1.0");
        }
        this.sign(accessor);
    }

    public void sign(OAuthAccessor accessor) throws IOException, OAuthException, URISyntaxException {
        OAuthSignatureMethod.newSigner(this, accessor).sign(this);
    }

    public HttpMessage toHttpRequest(OAuthClient.ParameterStyle style) throws IOException {
        return HttpMessage.newRequest(this, style.getReplacement());
    }

    public void validateMessage(OAuthAccessor accessor, OAuthValidator validator) throws OAuthException, IOException, URISyntaxException {
        validator.validateMessage(this, accessor);
    }

    public String getAuthorizationHeader(String realm) throws IOException {
        StringBuilder into = new StringBuilder();
        if (realm != null) {
            into.append(" realm=\"").append(OAuth.percentEncode(realm)).append('\"');
        }
        this.beforeGetParameter();
        if (this.parameters != null) {
            for (Map.Entry<String, String> parameter : this.parameters) {
                String name = OAuthMessage.toString(parameter.getKey());
                if (!name.startsWith("oauth_")) continue;
                if (into.length() > 0) {
                    into.append(",");
                }
                into.append(" ");
                into.append(OAuth.percentEncode(name)).append("=\"");
                into.append(OAuth.percentEncode(OAuthMessage.toString(parameter.getValue()))).append('\"');
            }
        }
        return AUTH_SCHEME + into.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAll(InputStream from, String encoding) throws IOException {
        if (from == null) {
            return null;
        }
        try {
            int n;
            StringBuilder into = new StringBuilder();
            InputStreamReader r = new InputStreamReader(from, encoding);
            char[] s = new char[512];
            while (0 < (n = r.read(s))) {
                into.append(s, 0, n);
            }
            String string = into.toString();
            return string;
        }
        finally {
            from.close();
        }
    }

    public static List<OAuth.Parameter> decodeAuthorization(String authorization) {
        Matcher m;
        ArrayList<OAuth.Parameter> into = new ArrayList<OAuth.Parameter>();
        if (authorization != null && (m = AUTHORIZATION.matcher(authorization)).matches() && AUTH_SCHEME.equalsIgnoreCase(m.group(1))) {
            for (String nvp : m.group(2).split("\\s*,\\s*")) {
                m = NVP.matcher(nvp);
                if (!m.matches()) continue;
                String name = OAuth.decodePercent(m.group(1));
                String value = OAuth.decodePercent(m.group(2));
                into.add(new OAuth.Parameter(name, value));
            }
        }
        return into;
    }

    private static final String toString(Object from) {
        return from == null ? null : from.toString();
    }
}

