/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.Hash;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.lib.Bytes;
import tdb.cmdline.CmdTDB;

public class tdbnode
extends CmdTDB {
    public static void main(String ... argv) {
        CmdTDB.init();
        new tdbnode(argv).mainRun();
    }

    protected tdbnode(String[] argv) {
        super(argv);
    }

    protected String getSummary() {
        return this.getCommandName() + " NodeId ...";
    }

    protected void exec() {
        DatasetGraphTDB dsg = this.getDatasetGraphTDB();
        NodeTable nodeTable = dsg.getTripleTable().getNodeTupleTable().getNodeTable();
        Iterator iter = super.getPositional().iterator();
        if (!iter.hasNext()) {
            System.err.println("No node ids");
            return;
        }
        while (iter.hasNext()) {
            String id = (String)iter.next();
            try {
                long x = Long.parseLong(id);
                NodeId nodeId = new NodeId(x);
                Node n = nodeTable.getNodeForNodeId(nodeId);
                Hash h = new Hash(16);
                NodeLib.setHash(h, n);
                String str = Bytes.asHex((byte[])h.getBytes());
                System.out.printf("%s %08d 0x%s # %s\n", id, x, str, n);
            }
            catch (Exception ex) {
                System.out.println("Failed to decode: " + id);
            }
        }
    }
}

