/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.bulkloader3;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.jena.tdb.store.bulkloader3.DataStreamFactory;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleOutputStream
implements Sink<Tuple<Long>> {
    private DataOutputStream out;

    public TupleOutputStream(OutputStream out) {
        this.out = DataStreamFactory.createDataOutputStream(out);
    }

    public void send(Tuple<Long> tuple) {
        Iterator iter = tuple.iterator();
        while (iter.hasNext()) {
            try {
                this.out.writeLong((Long)iter.next());
            }
            catch (IOException e) {
                new AtlasException((Throwable)e);
            }
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            new AtlasException((Throwable)e);
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            new AtlasException((Throwable)e);
        }
    }
}

