/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.bulkloader3;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollectorNodeId;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.bulkloader3.ProgressLogger;
import org.openjena.atlas.data.DataBag;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.Tuple;
import tdb.tdbloader3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTableBuilder
implements Sink<Quad> {
    private NodeTable nodeTable;
    private DataBag<Tuple<Long>> outputTriples;
    private DataBag<Tuple<Long>> outputQuads;
    private ProgressLogger monitor;
    private StatsCollectorNodeId stats;

    public NodeTableBuilder(DatasetGraphTDB dsg, ProgressLogger monitor, DataBag<Tuple<Long>> outputTriples, DataBag<Tuple<Long>> outputQuads) {
        this.monitor = monitor;
        NodeTupleTable ntt = dsg.getTripleTable().getNodeTupleTable();
        this.nodeTable = ntt.getNodeTable();
        this.outputTriples = outputTriples;
        this.outputQuads = outputQuads;
        this.stats = new StatsCollectorNodeId();
    }

    public void send(Quad quad) {
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g = null;
        if (!quad.isTriple() && !quad.isDefaultGraph()) {
            g = quad.getGraph();
        }
        NodeId sId = this.nodeTable.getAllocateNodeId(s);
        NodeId pId = this.nodeTable.getAllocateNodeId(p);
        NodeId oId = this.nodeTable.getAllocateNodeId(o);
        if (g != null) {
            NodeId gId = this.nodeTable.getAllocateNodeId(g);
            this.outputQuads.send((Object)Tuple.create((Object[])new Long[]{gId.getId(), sId.getId(), pId.getId(), oId.getId()}));
            if (!tdbloader3.no_stats) {
                this.stats.record(gId, sId, pId, oId);
            }
        } else {
            this.outputTriples.send((Object)Tuple.create((Object[])new Long[]{sId.getId(), pId.getId(), oId.getId()}));
            if (!tdbloader3.no_stats) {
                this.stats.record(null, sId, pId, oId);
            }
        }
        this.monitor.tick();
    }

    public void flush() {
        this.outputTriples.flush();
        this.outputQuads.flush();
        this.nodeTable.sync();
    }

    public void close() {
        this.flush();
    }

    public StatsCollectorNodeId getCollector() {
        return this.stats;
    }
}

