/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.bulkloader3;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.data.AbstractDataBag;
import org.openjena.atlas.data.SerializationFactory;
import org.openjena.atlas.data.ThresholdPolicy;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.IteratorResourceClosing;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.Sink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiThreadedSortedDataBag<E>
extends AbstractDataBag<E> {
    private final ThresholdPolicy<E> policy;
    private final SerializationFactory<E> serializationFactory;
    private final Comparator<? super E> comparator;
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1));
    private final RejectedExecutionHandler block = new RejectedExecutionHandler(){

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            r.run();
        }
    };
    private boolean multithreaded = true;
    protected boolean finishedAdding = false;
    protected boolean spilled = false;
    protected boolean closed = false;
    public static int MAX_SPILL_FILES = 100;

    public MultiThreadedSortedDataBag(ThresholdPolicy<E> policy, SerializationFactory<E> serializerFactory, Comparator<? super E> comparator) {
        this.policy = policy;
        this.serializationFactory = serializerFactory;
        this.comparator = comparator;
        this.pool.setRejectedExecutionHandler(this.block);
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new AtlasException("SortedDataBag is closed, no operations can be performed on it.");
        }
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isDistinct() {
        return false;
    }

    protected List<File> getSpillFiles() {
        return super.getSpillFiles();
    }

    public void add(E item) {
        this.checkClosed();
        if (this.finishedAdding) {
            throw new AtlasException("SortedDataBag: Cannot add any more items after the writing phase is complete.");
        }
        if (this.policy.isThresholdExceeded()) {
            this.spill();
        }
        if (this.memory.add(item)) {
            this.policy.increment(item);
            ++this.size;
        }
    }

    public void spill() {
        if (this.memory.size() > 0) {
            OutputStream out;
            try {
                out = this.getSpillStream();
            }
            catch (IOException e) {
                throw new AtlasException((Throwable)e);
            }
            Object[] array = this.memory.toArray();
            Sink serializer = this.serializationFactory.createSerializer(out);
            if (this.multithreaded) {
                this.pool.execute(new Spiller(array, serializer));
            } else {
                this.spill(array, serializer);
            }
            this.spilled = true;
            this.policy.reset();
            this.memory.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void spill(Object[] array, Sink<E> serializer) {
        Arrays.sort(array, this.comparator);
        try {
            for (Object tuple : array) {
                serializer.send(tuple);
            }
        }
        finally {
            serializer.close();
        }
    }

    public void flush() {
        this.spill();
    }

    public Iterator<E> iterator() {
        this.preMerge();
        return this.iterator(this.getSpillFiles().size());
    }

    private Iterator<E> iterator(int size) {
        this.checkClosed();
        int memSize = this.memory.size();
        if (!this.finishedAdding && memSize > 1) {
            Object[] array = this.memory.toArray();
            Arrays.sort(array, this.comparator);
            this.memory = Arrays.asList(array);
        }
        this.finishedAdding = true;
        if (this.spilled) {
            if (this.multithreaded && !this.pool.isShutdown()) {
                this.pool.shutdown();
                try {
                    this.pool.awaitTermination(10L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    throw new AtlasException((Throwable)e);
                }
            }
            ArrayList inputs = new ArrayList(size + (memSize > 0 ? 1 : 0));
            if (memSize > 0) {
                inputs.add(this.memory.iterator());
            }
            for (int i = 0; i < size; ++i) {
                File spillFile = this.getSpillFiles().get(i);
                try {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(spillFile));
                    Iterator deserializer = this.serializationFactory.createDeserializer((InputStream)in);
                    IteratorResourceClosing iteratorResourceClosing = new IteratorResourceClosing(deserializer, (java.io.Closeable)in);
                    inputs.add(iteratorResourceClosing);
                    continue;
                }
                catch (FileNotFoundException e) {
                    for (Iterator iterator : inputs) {
                        Iter.close((Iterator)iterator);
                    }
                    throw new AtlasException("Cannot find one of the spill files", (Throwable)e);
                }
            }
            SpillSortIterator<? super E> ssi = new SpillSortIterator<E>(inputs, this.comparator);
            this.registerCloseableIterator(ssi);
            return ssi;
        }
        if (memSize > 0) {
            return this.memory.iterator();
        }
        return Iter.nullIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preMerge() {
        if (this.getSpillFiles() == null || this.getSpillFiles().size() <= MAX_SPILL_FILES) {
            return;
        }
        try {
            while (this.getSpillFiles().size() > MAX_SPILL_FILES) {
                Sink sink = this.serializationFactory.createSerializer(this.getSpillStream());
                Iterator<E> ssi = this.iterator(MAX_SPILL_FILES);
                try {
                    while (ssi.hasNext()) {
                        sink.send(ssi.next());
                    }
                }
                finally {
                    Iter.close(ssi);
                    sink.close();
                }
                ArrayList<File> toRemove = new ArrayList<File>(MAX_SPILL_FILES);
                for (int i = 0; i < MAX_SPILL_FILES; ++i) {
                    File file = this.getSpillFiles().get(i);
                    file.delete();
                    toRemove.add(file);
                }
                this.getSpillFiles().removeAll(toRemove);
                this.memory = new ArrayList();
            }
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
    }

    public void close() {
        if (!this.closed) {
            this.closeIterators();
            this.deleteSpillFiles();
            this.memory = null;
            this.closed = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpillSortIterator<T>
    implements Iterator<T>,
    Closeable {
        private final List<Iterator<T>> inputs;
        private final Comparator<? super T> comp;
        private final PriorityQueue<Item<T>> minHeap;

        public SpillSortIterator(List<Iterator<T>> inputs, Comparator<? super T> comp) {
            this.inputs = inputs;
            this.comp = comp;
            this.minHeap = new PriorityQueue(inputs.size());
            for (int i = 0; i < inputs.size(); ++i) {
                this.replaceItem(i);
            }
        }

        private void replaceItem(int index) {
            Iterator<T> it = this.inputs.get(index);
            if (it.hasNext()) {
                T tuple = it.next();
                this.minHeap.add(new Item<T>(index, tuple, this.comp));
            }
        }

        @Override
        public boolean hasNext() {
            return this.minHeap.peek() != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Item<T> curr = this.minHeap.poll();
            this.replaceItem(curr.getIndex());
            return curr.getTuple();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SpillSortIterator.remove");
        }

        public void close() {
            for (Iterator<T> it : this.inputs) {
                Iter.close(it);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class Item<U>
        implements Comparable<Item<U>> {
            private final int index;
            private final U tuple;
            private final Comparator<? super U> c;

            public Item(int index, U tuple, Comparator<? super U> c) {
                this.index = index;
                this.tuple = tuple;
                this.c = c;
            }

            public int getIndex() {
                return this.index;
            }

            public U getTuple() {
                return this.tuple;
            }

            @Override
            public int compareTo(Item<U> o) {
                return null != this.c ? this.c.compare(this.tuple, o.getTuple()) : ((Comparable)this.tuple).compareTo(o.getTuple());
            }

            public boolean equals(Object obj) {
                if (obj instanceof Item) {
                    return this.compareTo((Item)obj) == 0;
                }
                return false;
            }

            public int hashCode() {
                return this.tuple.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Spiller
    implements Runnable {
        private Object[] array;
        private Sink<E> serializer;

        public Spiller(Object[] array, Sink<E> serializer) {
            this.array = array;
            this.serializer = serializer;
        }

        @Override
        public void run() {
            MultiThreadedSortedDataBag.this.spill(this.array, this.serializer);
        }
    }
}

