/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.transaction;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.tdb.transaction.DatasetBuilderTxn;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTxn;
import com.hp.hpl.jena.tdb.transaction.Journal;
import com.hp.hpl.jena.tdb.transaction.JournalControl;
import com.hp.hpl.jena.tdb.transaction.SysTxnState;
import com.hp.hpl.jena.tdb.transaction.TDBTransactionException;
import com.hp.hpl.jena.tdb.transaction.Transaction;
import com.hp.hpl.jena.tdb.transaction.TransactionLifecycle;
import com.hp.hpl.jena.tdb.transaction.TxnState;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.openjena.atlas.lib.Pair;
import org.openjena.atlas.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager {
    private static boolean checking = true;
    private static Logger log = LoggerFactory.getLogger(TransactionManager.class);
    private Set<Transaction> activeTransactions = new HashSet<Transaction>();
    private boolean recordHistory = false;
    private List<Pair<Transaction, TxnPoint>> transactionStateTransition;
    int maxQueue = 0;
    List<Transaction> commitedAwaitingFlush = new ArrayList<Transaction>();
    static AtomicLong transactionId = new AtomicLong(1L);
    AtomicLong activeReaders = new AtomicLong(0L);
    AtomicLong activeWriters = new AtomicLong(0L);
    AtomicLong finishedReaders = new AtomicLong(0L);
    AtomicLong committedWriters = new AtomicLong(0L);
    AtomicLong abortedWriters = new AtomicLong(0L);
    private Semaphore writersWaiting = new Semaphore(1, true);
    private BlockingQueue<Transaction> queue = new LinkedBlockingDeque<Transaction>();
    private Thread committerThread;
    private DatasetGraphTDB baseDataset;
    private Journal journal;
    private TSM[] actions = new TSM[]{new TSM_Counters(), new TSM_Logger(), this.recordHistory ? new TSM_Record() : null, new TSM_WriteBackEndTxn()};
    public static final boolean DEBUG = false;

    public synchronized boolean activeTransactions() {
        return !this.activeTransactions.isEmpty();
    }

    private void record(Transaction txn, TxnPoint state) {
        if (!this.recordHistory) {
            return;
        }
        this.initRecordingState();
        this.transactionStateTransition.add((Pair<Transaction, TxnPoint>)new Pair((Object)txn, (Object)state));
    }

    static long inc(AtomicLong x) {
        return x.getAndIncrement();
    }

    static long dec(AtomicLong x) {
        return x.decrementAndGet();
    }

    public TransactionManager(DatasetGraphTDB dsg) {
        this.baseDataset = dsg;
        this.journal = Journal.create(dsg.getLocation());
    }

    public void closedown() {
        this.processDelayedReplayQueue(null);
        this.journal.close();
    }

    private Transaction createTransaction(DatasetGraphTDB dsg, ReadWrite mode, String label) {
        Transaction txn = new Transaction(dsg, mode, transactionId.getAndIncrement(), label, this);
        return txn;
    }

    public DatasetGraphTxn begin(ReadWrite mode) {
        return this.begin(mode, null);
    }

    public DatasetGraphTxn begin(ReadWrite mode, String label) {
        if (mode == ReadWrite.WRITE) {
            try {
                this.writersWaiting.acquire();
            }
            catch (InterruptedException e) {
                log.error(label, (Throwable)e);
                throw new TDBTransactionException(e);
            }
        }
        return this.begin$(mode, label);
    }

    private synchronized DatasetGraphTxn begin$(ReadWrite mode, String label) {
        if (mode == ReadWrite.WRITE && this.activeWriters.get() > 0L) {
            throw new TDBTransactionException("Existing active write transaction");
        }
        DatasetGraphTDB dsg = this.baseDataset;
        if (!this.commitedAwaitingFlush.isEmpty()) {
            dsg = this.commitedAwaitingFlush.get(this.commitedAwaitingFlush.size() - 1).getActiveDataset();
        }
        Transaction txn = this.createTransaction(dsg, mode, label);
        TransactionManager.log("begin$", txn);
        DatasetGraphTxn dsgTxn = (DatasetGraphTxn)new DatasetBuilderTxn(this).build(txn, mode, dsg);
        txn.setActiveDataset(dsgTxn);
        for (TransactionLifecycle component : dsgTxn.getTransaction().components()) {
            component.begin(dsgTxn.getTransaction());
        }
        this.noteStartTxn(txn);
        return dsgTxn;
    }

    public synchronized void notifyCommit(Transaction transaction) {
        if (!this.activeTransactions.contains(transaction)) {
            SystemTDB.errlog.warn("Transaction not active: " + transaction.getTxnId());
        }
        this.noteTxnCommit(transaction);
        switch (transaction.getMode()) {
            case READ: {
                break;
            }
            case WRITE: {
                this.writersWaiting.release();
            }
        }
    }

    public synchronized void notifyAbort(Transaction transaction) {
        if (!this.activeTransactions.contains(transaction)) {
            SystemTDB.errlog.warn("Transaction not active: " + transaction.getTxnId());
        }
        this.noteTxnAbort(transaction);
        switch (transaction.getMode()) {
            case READ: {
                break;
            }
            case WRITE: {
                this.writersWaiting.release();
            }
        }
    }

    private void enactTransaction(Transaction transaction) {
        for (TransactionLifecycle x : transaction.components()) {
            x.commitEnact(transaction);
            x.commitClearup(transaction);
        }
        transaction.signalEnacted();
    }

    private void processDelayedReplayQueue(Transaction txn) {
        if (this.activeReaders.get() != 0L || this.activeWriters.get() != 0L) {
            if (this.queue.size() > 0 && TransactionManager.log()) {
                TransactionManager.log(String.format("Pending transactions: R=%s / W=%s", this.activeReaders, this.activeWriters), txn);
            }
            return;
        }
        if (TransactionManager.log()) {
            TransactionManager.log("Start flush delayed commits", txn);
        }
        if (this.queue.size() == 0 && txn != null) {
            return;
        }
        while (this.queue.size() > 0) {
            try {
                Transaction txn2 = this.queue.take();
                if (txn2.getMode() == ReadWrite.READ) continue;
                if (TransactionManager.log()) {
                    TransactionManager.log("Flush delayed commit of " + txn2.getLabel(), txn);
                }
                this.checkReplaySafe();
                this.enactTransaction(txn2);
                this.commitedAwaitingFlush.remove(txn2);
            }
            catch (InterruptedException ex) {
                Log.fatal((Object)this, (String)"Interruped!", (Throwable)ex);
            }
        }
        this.checkReplaySafe();
        JournalControl.replay(this.journal, this.baseDataset);
        this.checkReplaySafe();
        if (TransactionManager.log()) {
            TransactionManager.log("End flush delayed commits", txn);
        }
    }

    private static void checkNodesDatJrnl(String label, Transaction txn) {
        String x;
        long len;
        if (txn != null && (len = new File(x = txn.getBaseDataset().getLocation().getPath(label + ": nodes.dat-jrnl")).length()) != 0L) {
            TransactionManager.log("nodes.dat-jrnl: not empty", txn);
        }
    }

    private void checkReplaySafe() {
        if (!checking) {
            return;
        }
        if (this.activeReaders.get() != 0L || this.activeWriters.get() != 0L) {
            log.error("There are now active transactions");
        }
    }

    public synchronized void notifyClose(Transaction txn) {
        if (txn.getState() == TxnState.ACTIVE) {
            String x = txn.getBaseDataset().getLocation().getDirectoryPath();
            SystemTDB.syslog.warn("close: Transaction not commited or aborted: Transaction: " + txn.getTxnId() + " @ " + x);
            txn.abort();
            txn.close();
            return;
        }
        this.noteTxnClose(txn);
    }

    private void noteStartTxn(Transaction transaction) {
        switch (transaction.getMode()) {
            case READ: {
                this.readerStarts(transaction);
                break;
            }
            case WRITE: {
                this.writerStarts(transaction);
            }
        }
        this.transactionStarts(transaction);
    }

    private void noteTxnCommit(Transaction transaction) {
        switch (transaction.getMode()) {
            case READ: {
                this.readerFinishes(transaction);
                break;
            }
            case WRITE: {
                this.writerCommits(transaction);
            }
        }
        this.transactionFinishes(transaction);
    }

    private void noteTxnAbort(Transaction transaction) {
        switch (transaction.getMode()) {
            case READ: {
                this.readerFinishes(transaction);
                break;
            }
            case WRITE: {
                this.writerAborts(transaction);
            }
        }
        this.transactionFinishes(transaction);
    }

    private void noteTxnClose(Transaction transaction) {
        this.transactionCloses(transaction);
    }

    public boolean recording() {
        return this.recordHistory;
    }

    public void recording(boolean flag) {
        this.recordHistory = flag;
        if (this.recordHistory) {
            this.initRecordingState();
        }
    }

    public void clearRecordingState() {
        this.initRecordingState();
        this.transactionStateTransition.clear();
    }

    private void initRecordingState() {
        if (this.transactionStateTransition == null) {
            this.transactionStateTransition = new ArrayList<Pair<Transaction, TxnPoint>>();
        }
    }

    public Journal getJournal() {
        return this.journal;
    }

    private static boolean log() {
        return SystemTDB.syslog.isDebugEnabled() || log.isDebugEnabled();
    }

    private static void log(String msg, Transaction txn) {
        if (!TransactionManager.log()) {
            return;
        }
        if (txn == null) {
            TransactionManager.logger().debug("<No txn>: " + msg);
        } else {
            TransactionManager.logger().debug(txn.getLabel() + ": " + msg);
        }
    }

    private void logInternal(String action, Transaction txn) {
        if (!TransactionManager.log()) {
            return;
        }
        String txnStr = txn == null ? "<null>" : txn.getLabel();
        System.err.printf(String.format("%6s %s -- %s", action, txnStr, this.state()), new Object[0]);
    }

    private static Logger logger() {
        if (SystemTDB.syslog.isDebugEnabled()) {
            return SystemTDB.syslog;
        }
        return log;
    }

    public synchronized SysTxnState state() {
        return new SysTxnState(this);
    }

    private void transactionStarts(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.transactionStarts(txn);
        }
    }

    private void transactionFinishes(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.transactionFinishes(txn);
        }
    }

    private void transactionCloses(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.transactionCloses(txn);
        }
    }

    private void readerStarts(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.readerStarts(txn);
        }
    }

    private void readerFinishes(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.readerFinishes(txn);
        }
    }

    private void writerStarts(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.writerStarts(txn);
        }
    }

    private void writerCommits(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.writerCommits(txn);
        }
    }

    private void writerAborts(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.writerAborts(txn);
        }
    }

    class Committer
    implements Runnable {
        Committer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Transaction txn = (Transaction)TransactionManager.this.queue.take();
                        JournalControl.replay(txn);
                        TransactionManager transactionManager = TransactionManager.this;
                        synchronized (transactionManager) {
                            TransactionManager.this.commitedAwaitingFlush.remove(txn);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    Log.fatal((Object)this, (String)"Interruped!", (Throwable)ex);
                    continue;
                }
                break;
            }
        }
    }

    class TSM_Record
    extends TSM_Base {
        TSM_Record() {
        }

        public void transactionStarts(Transaction txn) {
            TransactionManager.this.record(txn, TxnPoint.BEGIN);
        }

        public void transactionFinishes(Transaction txn) {
            TransactionManager.this.record(txn, TxnPoint.CLOSE);
        }
    }

    class TSM_MRSW_Writer
    extends TSM_Base {
        TSM_MRSW_Writer() {
        }
    }

    class TSM_WriterWriteBack
    extends TSM_Base {
        TSM_WriterWriteBack() {
        }
    }

    class TSM_WriteBackEndTxn
    extends TSM_Base {
        TSM_WriteBackEndTxn() {
        }

        public void readerStarts(Transaction txn) {
            txn.getBaseDataset().getLock().enterCriticalSection(true);
        }

        public void writerStarts(Transaction txn) {
            txn.getBaseDataset().getLock().enterCriticalSection(true);
        }

        public void readerFinishes(Transaction txn) {
            txn.getBaseDataset().getLock().leaveCriticalSection();
            TransactionManager.this.processDelayedReplayQueue(txn);
        }

        public void writerCommits(Transaction txn) {
            txn.getBaseDataset().getLock().leaveCriticalSection();
            if (TransactionManager.this.activeReaders.get() == 0L) {
                if (TransactionManager.log()) {
                    TransactionManager.log("Commit immediately", txn);
                }
                TransactionManager.this.processDelayedReplayQueue(txn);
                TransactionManager.this.enactTransaction(txn);
                JournalControl.replay(txn);
            } else {
                TransactionManager.this.commitedAwaitingFlush.add(txn);
                TransactionManager.this.maxQueue = Math.max(TransactionManager.this.commitedAwaitingFlush.size(), TransactionManager.this.maxQueue);
                if (TransactionManager.log()) {
                    TransactionManager.log("Add to pending queue", txn);
                }
                TransactionManager.this.queue.add(txn);
            }
        }

        public void writerAborts(Transaction txn) {
            txn.getBaseDataset().getLock().leaveCriticalSection();
            TransactionManager.this.processDelayedReplayQueue(txn);
        }
    }

    class TSM_Counters
    implements TSM {
        TSM_Counters() {
        }

        public void transactionStarts(Transaction txn) {
            TransactionManager.this.activeTransactions.add(txn);
        }

        public void transactionFinishes(Transaction txn) {
            TransactionManager.this.activeTransactions.remove(txn);
        }

        public void transactionCloses(Transaction txn) {
        }

        public void readerStarts(Transaction txn) {
            TransactionManager.inc(TransactionManager.this.activeReaders);
        }

        public void readerFinishes(Transaction txn) {
            TransactionManager.dec(TransactionManager.this.activeReaders);
            TransactionManager.inc(TransactionManager.this.finishedReaders);
        }

        public void writerStarts(Transaction txn) {
            TransactionManager.inc(TransactionManager.this.activeWriters);
        }

        public void writerCommits(Transaction txn) {
            TransactionManager.dec(TransactionManager.this.activeWriters);
            TransactionManager.inc(TransactionManager.this.committedWriters);
        }

        public void writerAborts(Transaction txn) {
            TransactionManager.dec(TransactionManager.this.activeWriters);
            TransactionManager.inc(TransactionManager.this.abortedWriters);
        }
    }

    class TSM_LoggerDebug
    extends TSM_Base {
        TSM_LoggerDebug() {
        }

        public void readerStarts(Transaction txn) {
            TransactionManager.this.logInternal("start", txn);
        }

        public void readerFinishes(Transaction txn) {
            TransactionManager.this.logInternal("finish", txn);
        }

        public void writerStarts(Transaction txn) {
            TransactionManager.this.logInternal("begin", txn);
        }

        public void writerCommits(Transaction txn) {
            TransactionManager.this.logInternal("commit", txn);
        }

        public void writerAborts(Transaction txn) {
            TransactionManager.this.logInternal("abort", txn);
        }
    }

    class TSM_Logger
    extends TSM_Base {
        TSM_Logger() {
        }

        public void readerStarts(Transaction txn) {
            TransactionManager.log("start", txn);
        }

        public void readerFinishes(Transaction txn) {
            TransactionManager.log("finish", txn);
        }

        public void writerStarts(Transaction txn) {
            TransactionManager.log("begin", txn);
        }

        public void writerCommits(Transaction txn) {
            TransactionManager.log("commit", txn);
        }

        public void writerAborts(Transaction txn) {
            TransactionManager.log("abort", txn);
        }
    }

    class TSM_Base
    implements TSM {
        TSM_Base() {
        }

        public void transactionStarts(Transaction txn) {
        }

        public void transactionFinishes(Transaction txn) {
        }

        public void transactionCloses(Transaction txn) {
        }

        public void readerStarts(Transaction txn) {
        }

        public void readerFinishes(Transaction txn) {
        }

        public void writerStarts(Transaction txn) {
        }

        public void writerCommits(Transaction txn) {
        }

        public void writerAborts(Transaction txn) {
        }
    }

    private static interface TSM {
        public void transactionStarts(Transaction var1);

        public void transactionFinishes(Transaction var1);

        public void transactionCloses(Transaction var1);

        public void readerStarts(Transaction var1);

        public void readerFinishes(Transaction var1);

        public void writerStarts(Transaction var1);

        public void writerCommits(Transaction var1);

        public void writerAborts(Transaction var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TxnPoint {
        BEGIN,
        COMMIT,
        ABORT,
        CLOSE,
        QUEUE,
        UNQUEUE;

    }
}

