/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.transaction;

import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.file.BufferChannel;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.IndexMap;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.FileRef;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTxn;
import com.hp.hpl.jena.tdb.transaction.Journal;
import com.hp.hpl.jena.tdb.transaction.JournalEntry;
import com.hp.hpl.jena.tdb.transaction.JournalEntryType;
import com.hp.hpl.jena.tdb.transaction.NodeTableTrans;
import com.hp.hpl.jena.tdb.transaction.TDBTransactionException;
import com.hp.hpl.jena.tdb.transaction.Transaction;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.lib.FileOps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalControl {
    private static Logger log = LoggerFactory.getLogger(JournalControl.class);

    public static void print(Journal journal) {
        System.out.println("Size: " + journal.size());
        for (JournalEntry e : journal) {
            System.out.println(JournalEntry.format(e));
            System.out.println("Posn: " + journal.position() + " : (" + (journal.size() - journal.position()) + ")");
        }
    }

    public static void recovery(DatasetGraphTDB dsg) {
        if (dsg instanceof DatasetGraphTxn) {
            throw new TDBTransactionException("Recovery works on the base dataset, not a transactional one");
        }
        if (dsg.getLocation().isMem()) {
            return;
        }
        Journal journal = JournalControl.findJournal(dsg);
        if (journal == null || journal.isEmpty()) {
            return;
        }
        for (FileRef fileRef : dsg.getConfig().nodeTables.keySet()) {
            JournalControl.recoverNodeDat(dsg, fileRef);
        }
        JournalControl.recoverFromJournal(dsg, journal);
        journal.close();
        if (journal.getFilename() != null && FileOps.exists((String)journal.getFilename())) {
            FileOps.delete((String)journal.getFilename());
        }
    }

    private static Journal findJournal(DatasetGraphTDB dsg) {
        Location loc = dsg.getLocation();
        String journalFilename = loc.absolute("journal.jrnl");
        File f = new File(journalFilename);
        if (f.exists() && f.isFile() && f.length() > 0L) {
            return Journal.create(loc);
        }
        return null;
    }

    public static void recoverFromJournal(DatasetGraphTDB dsg, Journal jrnl) {
        long x;
        if (dsg instanceof DatasetGraphTxn) {
            throw new TDBTransactionException("Recovery works on the base dataset, not a transactional one");
        }
        if (jrnl.isEmpty()) {
            return;
        }
        long posn = 0L;
        while ((x = JournalControl.scanForCommit(jrnl, posn)) != -1L) {
            JournalControl.recoverSegment(jrnl, posn, x, dsg);
            posn = x;
        }
        jrnl.truncate(0L);
        dsg.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long scanForCommit(Journal jrnl, long startPosn) {
        Iterator<JournalEntry> iter = jrnl.entries(startPosn);
        try {
            while (iter.hasNext()) {
                JournalEntry e = iter.next();
                if (e.getType() != JournalEntryType.Commit) continue;
                long l = e.getEndPosition();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            Iter.close(iter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recoverSegment(Journal jrnl, long startPosn, long endPosn, DatasetGraphTDB dsg) {
        Iterator<JournalEntry> iter = jrnl.entries(startPosn);
        iter = jrnl.entries(startPosn);
        try {
            while (iter.hasNext()) {
                JournalEntry e = iter.next();
                if (e.getType() == JournalEntryType.Commit) {
                    if (e.getEndPosition() != endPosn) {
                        log.warn(String.format("Inconsistent: end at %d; expected %d", e.getEndPosition(), endPosn));
                    }
                    return;
                }
                JournalControl.replay(e, dsg);
            }
        }
        finally {
            Iter.close(iter);
        }
    }

    private static void recoverNodeDat(DatasetGraphTDB dsg, FileRef fileRef) {
        RecordFactory recordFactory = new RecordFactory(16, 8);
        NodeTable baseNodeTable = dsg.getConfig().nodeTables.get(fileRef);
        String objFilename = fileRef.getFilename() + "-" + "jrnl";
        objFilename = dsg.getLocation().absolute(objFilename);
        File jrnlFile = new File(objFilename);
        if (jrnlFile.exists() && jrnlFile.length() > 0L) {
            SystemTDB.syslog.info("Recovering node data: " + fileRef.getFilename());
            ObjectFile dataJrnl = FileFactory.createObjectFileDisk(objFilename);
            NodeTableTrans ntt = new NodeTableTrans(null, objFilename, baseNodeTable, new IndexMap(recordFactory), dataJrnl);
            ntt.append();
            ntt.close();
            dataJrnl.close();
            baseNodeTable.sync();
        }
        if (jrnlFile.exists()) {
            FileOps.delete((String)objFilename);
        }
    }

    public static void replay(Transaction transaction) {
        Journal journal = transaction.getJournal();
        DatasetGraphTDB dsg = transaction.getBaseDataset();
        JournalControl.replay(journal, dsg);
    }

    public static void replay(Journal journal, DatasetGraphTDB dsg) {
        if (journal.size() == 0L) {
            return;
        }
        journal.position(0L);
        dsg.getLock().enterCriticalSection(false);
        try {
            for (JournalEntry e : journal) {
                JournalControl.replay(e, dsg);
            }
        }
        catch (RuntimeException ex) {
            SystemTDB.syslog.error("Exception during journal replay", (Throwable)ex);
            throw ex;
        }
        finally {
            dsg.getLock().leaveCriticalSection();
        }
        Collection<BlockMgr> x = dsg.getConfig().blockMgrs.values();
        for (BlockMgr blkMgr : x) {
            blkMgr.syncForce();
        }
        journal.truncate(0L);
    }

    private static boolean replay(JournalEntry e, DatasetGraphTDB dsg) {
        Map<FileRef, BlockMgr> mgrs = dsg.getConfig().blockMgrs;
        switch (e.getType()) {
            case Block: {
                BlockMgr blkMgr = mgrs.get(e.getFileRef());
                Block blk = e.getBlock();
                log.debug("Replay: {} {}", (Object)e.getFileRef(), (Object)blk);
                blk.setModified(true);
                blkMgr.overwrite(blk);
                return true;
            }
            case Buffer: {
                BufferChannel chan = dsg.getConfig().bufferChannels.get(e.getFileRef());
                ByteBuffer bb = e.getByteBuffer();
                log.debug("Replay: {} {}", (Object)e.getFileRef(), (Object)bb);
                chan.write(bb, 0L);
                return true;
            }
            case Commit: {
                return false;
            }
            case Abort: 
            case Object: 
            case Checkpoint: {
                SystemTDB.errlog.warn("Unexpected block type: " + (Object)((Object)e.getType()));
            }
        }
        return false;
    }
}

