/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.transaction;

import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.file.BufferChannel;
import com.hp.hpl.jena.tdb.base.file.BufferChannelFile;
import com.hp.hpl.jena.tdb.base.file.BufferChannelMem;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.sys.FileRef;
import com.hp.hpl.jena.tdb.transaction.JournalEntry;
import com.hp.hpl.jena.tdb.transaction.JournalEntryType;
import com.hp.hpl.jena.tdb.transaction.TDBTransactionException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.zip.Adler32;
import org.openjena.atlas.iterator.IteratorSlotted;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.FileOps;
import org.openjena.atlas.lib.Sync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Journal
implements Iterable<JournalEntry>,
Sync,
Closeable {
    private static Logger log = LoggerFactory.getLogger(Journal.class);
    private BufferChannel channel;
    private long position;
    private static int Overhead = 16;
    private static final int NoId = 5;
    private ByteBuffer header = ByteBuffer.allocate(Overhead);
    private static int SizeofCRC = 4;
    private ByteBuffer crcTrailer = ByteBuffer.allocate(SizeofCRC);

    public static boolean exists(Location location) {
        if (location.isMem()) {
            return false;
        }
        return FileOps.exists((String)Journal.journalFilename(location));
    }

    public static Journal create(Location location) {
        BufferChannel chan = location.isMem() ? BufferChannelMem.create() : new BufferChannelFile(Journal.journalFilename(location));
        return new Journal(chan);
    }

    private static String journalFilename(Location location) {
        return location.absolute("journal.jrnl");
    }

    private Journal(String filename) {
        this(new BufferChannelFile(filename));
    }

    Journal(BufferChannel channel) {
        this.channel = channel;
        this.position = 0L;
    }

    public synchronized long writeJournal(JournalEntry entry) {
        long posn = this.write(entry.getType(), entry.getFileRef(), entry.getBlock());
        if (entry.getPosition() < 0L) {
            entry.setPosition(posn);
            entry.setEndPosition(this.position);
        }
        return posn;
    }

    public synchronized long write(JournalEntryType type, FileRef fileRef, Block block) {
        ByteBuffer buffer = block == null ? null : block.getByteBuffer();
        long posn = this.position;
        int bufferCapacity = 0;
        int len = 0;
        if (buffer != null) {
            bufferCapacity = buffer.capacity();
            len = buffer.remaining();
        }
        this.header.clear();
        this.header.putInt(type.id);
        this.header.putInt(bufferCapacity);
        this.header.putInt(fileRef.getId());
        int blkId = block == null ? 5 : block.getId().intValue();
        this.header.putInt(blkId);
        this.header.flip();
        this.channel.write(this.header);
        Adler32 adler = new Adler32();
        adler.update(this.header.array());
        if (len > 0) {
            int bufferLimit = buffer.limit();
            int bufferPosition = buffer.position();
            buffer.position(0);
            buffer.limit(bufferCapacity);
            for (int i = len; i < bufferCapacity; ++i) {
                buffer.put(i, (byte)0);
            }
            this.channel.write(buffer);
            adler.update(buffer.array());
            buffer.position(bufferPosition);
            buffer.limit(bufferLimit);
        }
        this.crcTrailer.clear();
        Bytes.setInt((int)((int)adler.getValue()), (byte[])this.crcTrailer.array());
        this.channel.write(this.crcTrailer);
        this.position += (long)(Overhead + len + SizeofCRC);
        return posn;
    }

    public synchronized JournalEntry readJournal(long id) {
        return this._readJournal(id);
    }

    private JournalEntry _readJournal(long id) {
        long x = this.channel.position();
        if (x != id) {
            this.channel.position(id);
        }
        JournalEntry entry = this._read();
        long x2 = this.channel.position();
        entry.setPosition(id);
        entry.setEndPosition(x2);
        if (x != id) {
            this.channel.position(x);
        }
        return entry;
    }

    private JournalEntry _read() {
        this.header.clear();
        int lenRead = this.channel.read(this.header);
        if (lenRead == -1) {
            throw new TDBTransactionException("Read off the end of a journal file");
        }
        this.header.rewind();
        int typeId = this.header.getInt();
        int len = this.header.getInt();
        int ref = this.header.getInt();
        int blockId = this.header.getInt();
        Adler32 adler = new Adler32();
        adler.update(this.header.array());
        JournalEntryType type = JournalEntryType.type(typeId);
        FileRef fileRef = FileRef.get(ref);
        ByteBuffer bb = ByteBuffer.allocate(len);
        lenRead = this.channel.read(bb);
        adler.update(bb.array());
        bb.rewind();
        this.crcTrailer.clear();
        lenRead = this.channel.read(this.crcTrailer);
        if (lenRead != SizeofCRC) {
            throw new TDBTransactionException("Feaild to read block checksum.");
        }
        int checksum = Bytes.getInt((byte[])this.crcTrailer.array());
        if (checksum != (int)adler.getValue()) {
            throw new TDBTransactionException("Checksum error reading from the Journal.");
        }
        Block block = new Block(blockId, bb);
        return new JournalEntry(type, fileRef, block);
    }

    public Iterator<JournalEntry> entries() {
        return new IteratorEntries(0L);
    }

    public synchronized Iterator<JournalEntry> entries(long startPosition) {
        return new IteratorEntries(startPosition);
    }

    @Override
    public Iterator<JournalEntry> iterator() {
        return this.entries();
    }

    public void sync() {
        this.channel.sync();
    }

    public void close() {
        this.channel.close();
    }

    public long size() {
        return this.channel.size();
    }

    public boolean isEmpty() {
        return this.channel.size() == 0L;
    }

    public void truncate(long size) {
        this.channel.truncate(size);
    }

    public void append() {
        this.position(this.size());
    }

    public long position() {
        return this.channel.position();
    }

    public void position(long posn) {
        this.channel.position(posn);
    }

    public String getFilename() {
        return this.channel.getFilename();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorEntries
    extends IteratorSlotted<JournalEntry> {
        JournalEntry slot = null;
        final long endPoint;
        long iterPosn;

        public IteratorEntries(long startPosition) {
            this.iterPosn = startPosition;
            this.endPoint = Journal.this.channel.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JournalEntry moveToNext() {
            Journal journal = Journal.this;
            synchronized (journal) {
                if (this.iterPosn >= this.endPoint) {
                    return null;
                }
                JournalEntry e = Journal.this._readJournal(this.iterPosn);
                this.iterPosn = e.getEndPosition();
                return e;
            }
        }

        protected boolean hasMore() {
            return this.iterPosn < this.endPoint;
        }
    }
}

