/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.transaction;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.JenaTransactionException;
import com.hp.hpl.jena.tdb.StoreConnection;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.migrate.DatasetGraphTrackActive;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTxn;
import com.hp.hpl.jena.tdb.transaction.TDBTransactionException;

public class DatasetGraphTransaction
extends DatasetGraphTrackActive {
    private ThreadLocalTxn txn = new ThreadLocalTxn();
    private final StoreConnection sConn;

    protected void finalize() throws Throwable {
        this.txn.remove();
    }

    public DatasetGraphTransaction(Location location) {
        this.sConn = StoreConnection.make(location);
    }

    public Location getLocation() {
        return this.sConn.getLocation();
    }

    public DatasetGraphTDB getDatasetGraphToQuery() {
        return this.get();
    }

    public DatasetGraphTDB getBaseDatasetGraph() {
        return this.sConn.getBaseDataset();
    }

    protected DatasetGraphTDB get() {
        if (this.isInTransaction()) {
            DatasetGraphTxn dsgTxn = (DatasetGraphTxn)this.txn.get();
            if (dsgTxn == null) {
                throw new TDBTransactionException("In a transaction but no transactional DatasetGraph");
            }
            return dsgTxn;
        }
        if (this.sConn.haveUsedInTransaction()) {
            throw new TDBTransactionException("Not in a transaction");
        }
        return this.sConn.getBaseDataset();
    }

    protected void checkActive() {
        if (this.sConn.haveUsedInTransaction() && !this.isInTransaction()) {
            throw new JenaTransactionException("Not in a transaction (" + this.getLocation() + ")");
        }
    }

    protected void checkNotActive() {
        if (this.sConn.haveUsedInTransaction() && this.isInTransaction()) {
            throw new JenaTransactionException("Currently in a transaction (" + this.getLocation() + ")");
        }
    }

    public boolean isInTransaction() {
        return this.txn.get() != null;
    }

    public void syncIfNotTransactional() {
        if (!this.sConn.haveUsedInTransaction()) {
            this.sConn.getBaseDataset().sync();
        }
    }

    protected void _begin(ReadWrite readWrite) {
        DatasetGraphTxn dsgTxn = this.sConn.begin(readWrite);
        this.txn.set(dsgTxn);
    }

    protected void _commit() {
        ((DatasetGraphTxn)this.txn.get()).commit();
    }

    protected void _abort() {
        ((DatasetGraphTxn)this.txn.get()).abort();
    }

    protected void _end() {
        ((DatasetGraphTxn)this.txn.get()).end();
        this.txn.set(null);
    }

    public String toString() {
        try {
            return this.get().toString();
        }
        catch (Throwable th) {
            return "DatasetGraphTransactional";
        }
    }

    protected void _close() {
        if (!this.sConn.haveUsedInTransaction() && this.get() != null) {
            DatasetGraphTDB dsg = this.get();
            dsg.sync();
            dsg.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ThreadLocalTxn
    extends ThreadLocal<DatasetGraphTxn> {
        ThreadLocalTxn() {
        }

        @Override
        protected DatasetGraphTxn initialValue() {
            return null;
        }
    }
}

