/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTransaction;

public class TDBInternal {
    public static NodeId getNodeId(Dataset ds, Node node) {
        return TDBInternal.getNodeId(ds.asDatasetGraph(), node);
    }

    public static NodeId getNodeId(DatasetGraph ds, Node node) {
        DatasetGraphTDB dsg = TDBInternal.getDatasetGraphTDB(ds);
        if (dsg == null) {
            return null;
        }
        NodeTable nodeTable = dsg.getQuadTable().getNodeTupleTable().getNodeTable();
        NodeId nodeId = nodeTable.getNodeIdForNode(node);
        return nodeId;
    }

    public static Node getNode(Dataset ds, NodeId nodeId) {
        return TDBInternal.getNode(ds.asDatasetGraph(), nodeId);
    }

    public static Node getNode(DatasetGraph ds, NodeId nodeId) {
        DatasetGraphTDB dsg = TDBInternal.getDatasetGraphTDB(ds);
        if (dsg == null) {
            return null;
        }
        NodeTable nodeTable = dsg.getQuadTable().getNodeTupleTable().getNodeTable();
        Node node = nodeTable.getNodeForNodeId(nodeId);
        return node;
    }

    public static DatasetGraphTDB getDatasetGraphTDB(Dataset ds) {
        return TDBInternal.getDatasetGraphTDB(ds.asDatasetGraph());
    }

    public static DatasetGraphTDB getDatasetGraphTDB(DatasetGraph dsg) {
        if (dsg instanceof DatasetGraphTransaction) {
            return ((DatasetGraphTransaction)dsg).getBaseDatasetGraph();
        }
        if (dsg instanceof DatasetGraphTDB) {
            return (DatasetGraphTDB)dsg;
        }
        return null;
    }
}

