/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.block.BlockConverter;
import com.hp.hpl.jena.tdb.base.block.BlockType;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordbuffer.RecordBufferPage;
import com.hp.hpl.jena.tdb.base.recordbuffer.RecordBufferPageMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreePageMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeRecords;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BPTreeRecordsMgr
extends BPTreePageMgr<BPTreeRecords> {
    private RecordBufferPageMgr rBuffPageMgr;

    BPTreeRecordsMgr(BPlusTree bpTree, RecordBufferPageMgr rBuffPageMgr) {
        super(bpTree, null, rBuffPageMgr.getBlockMgr());
        this.rBuffPageMgr = rBuffPageMgr;
        super.setConverter(new Block2BPTreeRecords(bpTree, bpTree.getRecordFactory()));
    }

    public BPTreeRecords create() {
        return (BPTreeRecords)super.create(BlockType.RECORD_BLOCK);
    }

    public RecordBufferPageMgr getRecordBufferPageMgr() {
        return this.rBuffPageMgr;
    }

    @Override
    public void startRead() {
        this.rBuffPageMgr.startRead();
    }

    @Override
    public void finishRead() {
        this.rBuffPageMgr.finishRead();
    }

    @Override
    public void startUpdate() {
        this.rBuffPageMgr.startUpdate();
    }

    @Override
    public void finishUpdate() {
        this.rBuffPageMgr.finishUpdate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Block2BPTreeRecords
    implements BlockConverter<BPTreeRecords> {
        private RecordBufferPageMgr.Block2RecordBufferPage recordBufferConverter;
        private BPlusTree bpTree;

        Block2BPTreeRecords(BPlusTree bpTree, RecordFactory recordFactory) {
            this.bpTree = bpTree;
            this.recordBufferConverter = new RecordBufferPageMgr.Block2RecordBufferPage(recordFactory);
        }

        @Override
        public BPTreeRecords fromBlock(Block block) {
            RecordBufferPage rbp = this.recordBufferConverter.fromBlock(block);
            return new BPTreeRecords(this.bpTree, rbp);
        }

        @Override
        public Block toBlock(BPTreeRecords t) {
            return this.recordBufferConverter.toBlock(t.getRecordBufferPage());
        }

        @Override
        public BPTreeRecords createFromBlock(Block block, BlockType bType) {
            RecordBufferPage rbp = this.recordBufferConverter.createFromBlock(block, bType);
            return new BPTreeRecords(this.bpTree, rbp);
        }
    }
}

