/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.objectfile;

import com.hp.hpl.jena.tdb.base.StorageException;
import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.IteratorInteger;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.ByteBufferLib;
import org.openjena.atlas.lib.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ObjectFileMem
implements ObjectFile {
    private List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private boolean closed = false;
    private final String label;
    private Block allocBlock = null;

    public ObjectFileMem(String label) {
        this.label = label;
    }

    public ObjectFileMem() {
        this("ObjectFileMem");
    }

    @Override
    public long length() {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        return this.buffers.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        return this.buffers.isEmpty();
    }

    @Override
    public ByteBuffer read(long id) {
        if (id < 0L || id >= (long)this.buffers.size()) {
            return null;
        }
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        ByteBuffer bb1 = this.buffers.get((int)id);
        ByteBuffer bb2 = ByteBufferLib.duplicate((ByteBuffer)bb1);
        return bb2;
    }

    @Override
    public long write(ByteBuffer bb) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        int id = this.buffers.size();
        this.buffers.add(null);
        this.write(id, bb);
        return id;
    }

    private void write(long id, ByteBuffer bb) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        ByteBuffer bb2 = ByteBufferLib.duplicate((ByteBuffer)bb);
        this.buffers.set((int)id, bb2);
    }

    @Override
    public Block allocWrite(int bytesSpace) {
        Block b;
        long id = this.buffers.size();
        this.buffers.add(null);
        this.allocBlock = b = new Block(id, ByteBuffer.allocate(bytesSpace));
        return b;
    }

    @Override
    public void completeWrite(Block block) {
        if (block.getId() != (long)(this.buffers.size() - 1)) {
            throw new StorageException();
        }
        if (block != this.allocBlock) {
            throw new StorageException();
        }
        this.allocBlock = null;
        this.write(block.getId(), block.getByteBuffer());
    }

    @Override
    public void reposition(long id) {
        if (this.allocBlock != null) {
            throw new StorageException("In the middle of an alloc-write");
        }
        int newSize = (int)id;
        if (newSize < 0 || newSize > this.buffers.size()) {
            throw new StorageException();
        }
        if (newSize == this.buffers.size()) {
            return;
        }
        ArrayList<ByteBuffer> buffers2 = new ArrayList<ByteBuffer>(newSize);
        int i = 0;
        while ((long)i < id) {
            buffers2.add(this.buffers.get(i));
            ++i;
        }
        this.buffers = buffers2;
    }

    @Override
    public void truncate(long size) {
        this.reposition(size);
    }

    @Override
    public Iterator<Pair<Long, ByteBuffer>> all() {
        int N = this.buffers.size();
        IteratorInteger iter = new IteratorInteger(0L, (long)N);
        Transform<Long, Pair<Long, ByteBuffer>> transform = new Transform<Long, Pair<Long, ByteBuffer>>(){

            public Pair<Long, ByteBuffer> convert(Long item) {
                ByteBuffer bb = (ByteBuffer)ObjectFileMem.this.buffers.get(item.intValue());
                return new Pair((Object)item, (Object)bb);
            }
        };
        return Iter.map((Iterator)iter, (Transform)transform);
    }

    public void sync() {
    }

    public void sync(boolean force) {
    }

    public void close() {
        this.closed = true;
    }

    @Override
    public String getLabel() {
        return this.label;
    }
}

